/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.migration.service;

import org.nuxeo.ecm.web.resources.api.Resource;
import org.nuxeo.ecm.web.resources.api.service.WebResourceManager;
import org.nuxeo.ecm.web.resources.core.ResourceDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ThemeMigrationService
extends DefaultComponent {
    protected static final String XP = "org.nuxeo.theme.services.ThemeService";
    protected static final String WR_XP = "org.nuxeo.ecm.platform.WebResources";

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("resources".equals(extensionPoint)) {
            if (contribution instanceof ResourceDescriptor) {
                ResourceDescriptor r = (ResourceDescriptor)contribution;
                String message = String.format("Resource '%s' on component %s should now be contributed to extension point '%s': a compatibility registration was performed but it may not be accurate.", r.getName(), contributor.getName(), WR_XP);
                DeprecationLogger.log((String)message, (String)"7.4");
                Framework.getRuntime().getWarnings().add(message);
                String path = r.getPath();
                if (path != null && !path.startsWith("/")) {
                    r.setUri("/" + path);
                }
                WebResourceManager wrm = (WebResourceManager)Framework.getService(WebResourceManager.class);
                wrm.registerResource((Resource)r);
            } else {
                String message = String.format("Warning: unknown contribution to target extension point '%s' of '%s'. Check your extension in component %s", extensionPoint, XP, contributor.getName());
                DeprecationLogger.log((String)message, (String)"7.4");
                Framework.getRuntime().getWarnings().add(message);
            }
        } else {
            String message = String.format("Warning: target extension point '%s' of '%s' is unknown as it has been removed since 7.4. Check your extension in component %s", extensionPoint, XP, contributor.getName());
            DeprecationLogger.log((String)message, (String)"7.4");
            Framework.getRuntime().getWarnings().add(message);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("resources".equals(extensionPoint) && contribution instanceof ResourceDescriptor) {
            ResourceDescriptor r = (ResourceDescriptor)contribution;
            WebResourceManager wrm = (WebResourceManager)Framework.getService(WebResourceManager.class);
            wrm.unregisterResource((Resource)r);
        }
    }
}

