/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.kerberos;

import java.util.ArrayList;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordPolicyService
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PasswordPolicyService.class);
    public static final String NAME = "passwordPolicyService";

    public void add(NextInterceptor next, AddOperationContext addContext) throws NamingException {
        LdapDN normName = addContext.getDn();
        Attributes entry = addContext.getEntry();
        log.debug("Adding the entry '{}' for DN '{}'.", (Object)AttributeUtils.toString((Attributes)entry), (Object)normName.getUpName());
        Object attr = null;
        if (entry.get("userPassword") != null) {
            String userPassword = "";
            String username = "";
            attr = entry.get("userPassword").get();
            if (attr instanceof String) {
                log.debug("Adding Attribute id : 'userPassword',  Values : [ '{}' ]", attr);
                userPassword = (String)attr;
            } else if (attr instanceof byte[]) {
                String string = StringTools.utf8ToString((byte[])((byte[])attr));
                if (log.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("'" + string + "' ( ");
                    sb.append(StringTools.dumpBytes((byte[])((byte[])attr)).trim());
                    sb.append(" )");
                    log.debug("Adding Attribute id : 'userPassword',  Values : [ {} ]", (Object)sb.toString());
                }
                userPassword = string;
            }
            if (entry.get("cn") != null) {
                attr = entry.get("cn").get();
                username = (String)attr;
            }
            this.check(username, userPassword);
        }
        next.add(addContext);
    }

    public void modify(NextInterceptor next, ModifyOperationContext modContext) throws NamingException {
        LdapDN name = modContext.getDn();
        ModificationItemImpl[] mods = modContext.getModItems();
        String operation = null;
        for (int ii = 0; ii < mods.length; ++ii) {
            Object userPassword;
            Attribute attr;
            String id;
            if (log.isDebugEnabled()) {
                switch (mods[ii].getModificationOp()) {
                    case 1: {
                        operation = "Adding";
                        break;
                    }
                    case 3: {
                        operation = "Removing";
                        break;
                    }
                    case 2: {
                        operation = "Replacing";
                    }
                }
            }
            if ((id = (attr = mods[ii].getAttribute()).getID()).equalsIgnoreCase("userPassword") && (userPassword = attr.get()) != null) {
                if (userPassword instanceof String) {
                    log.debug("{} Attribute id : 'userPassword',  Values : [ '{}' ]", (Object)operation, (Object)attr);
                } else if (userPassword instanceof byte[]) {
                    String string = StringTools.utf8ToString((byte[])((byte[])userPassword));
                    if (log.isDebugEnabled()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("'" + string + "' ( ");
                        sb.append(StringTools.dumpBytes((byte[])((byte[])userPassword)).trim());
                        sb.append(" )");
                        log.debug("{} Attribute id : 'userPassword',  Values : [ {} ]", (Object)operation, (Object)sb.toString());
                    }
                    userPassword = string;
                }
                this.check(name.getUpName(), (String)userPassword);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug(operation + " for entry '" + name.getUpName() + "' the attribute " + mods[ii].getAttribute());
        }
        next.modify(modContext);
    }

    void check(String username, String password) throws NamingException {
        int passwordLength = 6;
        int categoryCount = 2;
        int tokenSize = 3;
        if (!this.isValid(username, password, passwordLength, categoryCount, tokenSize)) {
            String explanation = this.buildErrorMessage(username, password, passwordLength, categoryCount, tokenSize);
            log.error(explanation);
            throw new NamingException(explanation);
        }
    }

    boolean isValid(String username, String password, int passwordLength, int categoryCount, int tokenSize) {
        return this.isValidPasswordLength(password, passwordLength) && this.isValidCategoryCount(password, categoryCount) && this.isValidUsernameSubstring(username, password, tokenSize);
    }

    boolean isValidPasswordLength(String password, int passwordLength) {
        return password.length() >= passwordLength;
    }

    boolean isValidCategoryCount(String password, int categoryCount) {
        int uppercase = 0;
        int lowercase = 0;
        int digit = 0;
        int nonAlphaNumeric = 0;
        char[] characters = password.toCharArray();
        for (int ii = 0; ii < characters.length; ++ii) {
            if (Character.isLowerCase(characters[ii])) {
                lowercase = 1;
                continue;
            }
            if (Character.isUpperCase(characters[ii])) {
                uppercase = 1;
                continue;
            }
            if (Character.isDigit(characters[ii])) {
                digit = 1;
                continue;
            }
            if (Character.isLetterOrDigit(characters[ii])) continue;
            nonAlphaNumeric = 1;
        }
        return uppercase + lowercase + digit + nonAlphaNumeric >= categoryCount;
    }

    boolean isValidUsernameSubstring(String username, String password, int tokenSize) {
        String[] tokens = username.split("[^a-zA-Z]");
        for (int ii = 0; ii < tokens.length; ++ii) {
            if (tokens[ii].length() < tokenSize || !password.matches("(?i).*" + tokens[ii] + ".*")) continue;
            return false;
        }
        return true;
    }

    private String buildErrorMessage(String username, String password, int passwordLength, int categoryCount, int tokenSize) {
        ArrayList<String> violations = new ArrayList<String>();
        if (!this.isValidPasswordLength(password, passwordLength)) {
            violations.add("length too short");
        }
        if (!this.isValidCategoryCount(password, categoryCount)) {
            violations.add("insufficient character mix");
        }
        if (!this.isValidUsernameSubstring(username, password, tokenSize)) {
            violations.add("contains portions of username");
        }
        StringBuffer sb = new StringBuffer("Password violates policy:  ");
        boolean isFirst = true;
        for (String violation : violations) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(violation);
        }
        return sb.toString();
    }
}

