/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.ecm.platform.ui.web.rest.FancyURLRequestWrapper;
import org.nuxeo.ecm.platform.ui.web.rest.FancyURLResponseWrapper;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.runtime.api.Framework;

public class FancyURLFilter
implements Filter {
    private static final Log log = LogFactory.getLog(FancyURLFilter.class);
    protected URLPolicyService urlService;
    protected ServletContext servletContext;

    public void init(FilterConfig conf) throws ServletException {
        log.debug((Object)"Nuxeo5 URLFilter started");
        this.servletContext = conf.getServletContext();
    }

    protected URLPolicyService getUrlService() {
        if (this.urlService == null) {
            this.urlService = (URLPolicyService)Framework.getService(URLPolicyService.class);
        }
        return this.urlService;
    }

    public void destroy() {
        this.urlService = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            DocumentView docView;
            this.getUrlService();
            this.urlService.initViewIdManager(this.servletContext, httpRequest, httpResponse);
            if (this.urlService.isCandidateForDecoding(httpRequest) && (docView = this.urlService.getDocumentViewFromRequest(httpRequest)) != null) {
                this.urlService.setDocumentViewInRequest(httpRequest, docView);
                String jsfOutcome = docView.getViewId();
                String target = this.urlService.getViewIdFromOutcome(jsfOutcome, httpRequest);
                RequestDispatcher dispatcher = target != null ? httpRequest.getRequestDispatcher(target) : httpRequest.getRequestDispatcher("/malformed_url_error_page.faces");
                request.setAttribute("nuxeo.force.url.encoding", (Object)Boolean.TRUE);
                dispatcher.forward((ServletRequest)new FancyURLRequestWrapper(httpRequest, docView), this.wrapResponse(httpRequest, httpResponse));
                return;
            }
            chain.doFilter(request, this.wrapResponse(httpRequest, httpResponse));
        }
        catch (IOException e) {
            String url = httpRequest.getRequestURL().toString();
            if (DownloadHelper.isClientAbortError((Throwable)e)) {
                DownloadHelper.logClientAbort((Exception)e);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Client disconnected from URL %s : %s", url, e.getMessage()));
                }
            }
            throw new IOException("On requestURL: " + url, e);
        }
        catch (ServletException e) {
            String url = httpRequest.getRequestURL().toString();
            if (DownloadHelper.isClientAbortError((Throwable)e)) {
                DownloadHelper.logClientAbort((Exception)((Object)e));
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Client disconnected from URL %s : %s", url, e.getMessage()));
                }
            }
            throw new ServletException("On requestURL: " + url, (Throwable)e);
        }
    }

    protected ServletResponse wrapResponse(HttpServletRequest request, HttpServletResponse response) {
        return new FancyURLResponseWrapper(response, request);
    }
}

