/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.gwt.client.controller;

import com.google.gwt.user.client.Element;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model.TilingInfo;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model.TilingModel;

public class TilingController {
    private static TilingInfo sourceTilingInfo;
    private static TilingModel model;

    public TilingController(TilingInfo tilingInfo, TilingModel tilingModel) {
        sourceTilingInfo = new TilingInfo(tilingInfo);
        model = tilingModel;
        this.setfilterPath("org_nuxeo_ecm_platform_pictures_tiles_gwt_client_XPointerFilter");
        this.setPointerAdapter("org_nuxeo_ecm_platform_pictures_tiles_gwt_client_PointerAdapter");
    }

    public static TilingInfo getSourcetilingInfo() {
        return sourceTilingInfo;
    }

    private native void setPointerAdapter(String var1);

    public static String filterPoint(int i, int j, int k, int l) {
        double zoom = model.getCurrentZoom();
        int startX = model.getViewAreaLeft();
        int endX = model.getViewAreaLeft() + model.getViewAreaWidth();
        int startY = model.getViewAreaTop();
        int endY = model.getViewAreaTop() + model.getViewAreaHeight();
        float zoomedAx = (float)((double)i * zoom);
        float zoomedAy = (float)((double)j * zoom);
        float zoomedBx = (float)((double)k * zoom);
        float zoomedBy = (float)((double)l * zoom);
        if (zoomedAx > (float)startX && zoomedBx < (float)endX && zoomedAy > (float)startY && zoomedBy < (float)endY) {
            int Ax = Math.round(zoomedAx);
            int Ay = Math.round(zoomedAy);
            int Bx = Math.round((float)Ax + (zoomedBx - zoomedAx));
            int By = Math.round((float)Ay + (zoomedBy - zoomedAy));
            return "[" + Ax + "," + Ay + "]:[" + Bx + "," + By + "]";
        }
        return "";
    }

    public static String filterPath(Element image, String xpath, int i, int j, int k, int l) {
        String src = image.getAttribute("src");
        int x = Integer.parseInt(src.substring(src.lastIndexOf("?x=") + 3, src.lastIndexOf("&y=")));
        int y = Integer.parseInt(src.substring(src.lastIndexOf("&y=") + 3, src.lastIndexOf("&date=")));
        float zommedAx = i + x * model.getTileWidth();
        float zommedAy = j + y * model.getTileHeight();
        float zommedBx = (float)(k - i) + zommedAx;
        float zommedBy = (float)(l - j) + zommedAy;
        double zoom = model.getCurrentZoom();
        int finalAx = (int)Math.round((double)zommedAx / zoom);
        int finalAy = (int)Math.round((double)zommedAy / zoom);
        int finalBx = (int)Math.round((double)zommedBx / zoom);
        int finalBy = (int)Math.round((double)zommedBy / zoom);
        return "#xpointer(image-range(//img,[" + finalAx + "," + finalAy + "],[" + finalBx + "," + finalBy + "]))";
    }

    public void updateAnnotationDecoration() {
        this.updateAnnotationView("org_nuxeo_ecm_platform_pictures_tiles_gwt_client_Update_Annotated_Document");
    }

    public native void updateAnnotationView(String var1);

    public native void setfilterPath(String var1);
}

