/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors;

import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.platform.rendering.fm.adapters.DocumentObjectWrapper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.ContentInputType;
import org.nuxeo.template.api.InputType;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.processors.HtmlBodyExtractor;
import org.nuxeo.template.processors.InputBindingResolver;

public abstract class AbstractBindingResolver
implements InputBindingResolver {
    protected Log log = LogFactory.getLog(AbstractBindingResolver.class);
    protected DocumentObjectWrapper nuxeoWrapper = new DocumentObjectWrapper(null);

    protected abstract Object handleLoop(String var1, Object var2);

    protected abstract Object handlePictureField(String var1, Blob var2);

    protected abstract void handleBlobField(String var1, Blob var2);

    protected String handleHtmlField(String paramName, String htmlValue) {
        return HtmlBodyExtractor.extractHtmlBody(htmlValue);
    }

    protected DocumentObjectWrapper getWrapper() {
        return this.nuxeoWrapper;
    }

    @Override
    public void resolve(List<TemplateInput> inputParams, Map<String, Object> context, TemplateBasedDocument templateBasedDocument) {
        for (TemplateInput param : inputParams) {
            try {
                if (param.isSourceValue()) {
                    if (param.getType() == InputType.Content) {
                        Serializable propValue;
                        if (ContentInputType.HtmlPreview.getValue().equals(param.getSource())) {
                            BlobHolder bh = (BlobHolder)templateBasedDocument.getAdaptedDoc().getAdapter(BlobHolder.class);
                            String htmlValue = this.handleHtmlField(param.getName(), this.getHtmlValue(bh));
                            context.put(param.getName(), htmlValue);
                            continue;
                        }
                        if (ContentInputType.BlobContent.getValue().equals(param.getSource())) {
                            propValue = templateBasedDocument.getAdaptedDoc().getPropertyValue(param.getSource());
                            if (propValue != null && propValue instanceof Blob) {
                                Blob blobValue = (Blob)propValue;
                                context.put(param.getName(), blobValue.getString());
                                this.handleBlobField(param.getName(), blobValue);
                            }
                        } else {
                            propValue = templateBasedDocument.getAdaptedDoc().getPropertyValue(param.getSource());
                            if (propValue instanceof String) {
                                String stringContent = (String)((Object)propValue);
                                String htmlValue = this.handleHtmlField(param.getName(), stringContent);
                                context.put(param.getName(), htmlValue);
                            }
                        }
                    }
                    Property property = null;
                    try {
                        property = templateBasedDocument.getAdaptedDoc().getProperty(param.getSource());
                    }
                    catch (PropertyException e) {
                        this.log.warn((Object)("Unable to ready property " + param.getSource()), (Throwable)e);
                    }
                    Serializable value = null;
                    if (property != null) {
                        value = property.getValue();
                    }
                    if (value != null) {
                        if (param.getType() == InputType.Content) continue;
                        if (Blob.class.isAssignableFrom(value.getClass())) {
                            Blob blob = (Blob)value;
                            if (param.getType() != InputType.PictureProperty) continue;
                            if (blob.getMimeType() == null || "".equals(blob.getMimeType().trim())) {
                                blob.setMimeType("image/jpeg");
                            }
                            context.put(param.getName(), this.handlePictureField(param.getName(), blob));
                            continue;
                        }
                        if (param.isAutoLoop()) {
                            Object loopVal = this.handleLoop(param.getName(), property);
                            context.put(param.getName(), loopVal);
                            continue;
                        }
                        context.put(param.getName(), this.nuxeoWrapper.wrap((Object)property));
                        continue;
                    }
                    if (property != null) {
                        Type pType = property.getType();
                        if (pType.getName().equals("boolean")) {
                            context.put(param.getName(), new Boolean(false));
                        } else if (pType.getName().equals("date")) {
                            context.put(param.getName(), new Date());
                        } else if (pType.getName().equals("string")) {
                            context.put(param.getName(), "");
                        } else if (pType.getName().equals(InputType.Content)) {
                            context.put(param.getName(), "");
                        } else {
                            context.put(param.getName(), "!NOVALUE!");
                        }
                        if (param.getType() != InputType.PictureProperty) continue;
                        context.put(param.getName(), this.handlePictureField(param.getName(), null));
                        continue;
                    }
                    if (!param.getType().equals((Object)InputType.PictureProperty)) continue;
                    context.put(param.getName(), this.handlePictureField(param.getName(), null));
                    continue;
                }
                if (InputType.StringValue.equals((Object)param.getType())) {
                    context.put(param.getName(), param.getStringValue());
                    continue;
                }
                if (InputType.BooleanValue.equals((Object)param.getType())) {
                    context.put(param.getName(), param.getBooleanValue());
                    continue;
                }
                if (!InputType.DateValue.equals((Object)param.getType())) continue;
                context.put(param.getName(), param.getDateValue());
            }
            catch (TemplateModelException | IOException e) {
                this.log.warn((Object)("Unable to handle binding for param " + param.getName()), e);
            }
        }
    }

    protected String getHtmlValue(BlobHolder bh) throws IOException {
        if (bh == null) {
            return "";
        }
        Blob blob = bh.getBlob();
        if (blob != null && "text/html".equals(blob.getMimeType())) {
            return blob.getString();
        }
        ConversionService conversion = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder htmlBh = conversion.convertToMimeType("text/html", bh, Collections.emptyMap());
        if (htmlBh != null) {
            return htmlBh.getBlob().getString();
        }
        if (blob != null && blob.getMimeType() != null && blob.getMimeType().startsWith("text/")) {
            return blob.getString();
        }
        return "";
    }
}

