/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.RedisFailoverExecutor;
import org.nuxeo.ecm.core.redis.RedisHostDescriptor;
import org.nuxeo.ecm.core.redis.RedisPoolDescriptor;
import org.nuxeo.ecm.core.redis.RedisPoolExecutor;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Pool;

@XObject(value="sentinel")
public class RedisSentinelDescriptor
extends RedisPoolDescriptor {
    @XNodeList(value="host", type=RedisHostDescriptor[].class, componentType=RedisHostDescriptor.class)
    public RedisHostDescriptor[] hosts = new RedisHostDescriptor[0];
    @XNode(value="master")
    public String master = "master";
    @XNode(value="failoverTimeout")
    public int failoverTimeout = 300;

    @Override
    public RedisExecutor newExecutor() throws RuntimeException {
        RedisPoolExecutor base = new RedisPoolExecutor((Pool<Jedis>)new JedisSentinelPool(this.master, this.toSentinels(this.hosts), (GenericObjectPoolConfig)new JedisPoolConfig(), this.timeout, this.password, this.database));
        return new RedisFailoverExecutor(this.failoverTimeout, base);
    }

    protected Set<String> toSentinels(RedisHostDescriptor[] hosts) {
        HashSet<String> sentinels = new HashSet<String>();
        for (RedisHostDescriptor host : hosts) {
            sentinels.add(host.name + ":" + host.port);
        }
        return sentinels;
    }
}

