/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.HtmlInterpreter;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import java.util.ArrayList;
import java.util.List;

public class GridParser
implements ElementParser {
    private static final String ROW_TAG = "row";
    private static final String CELL_TAG = "cell";
    private static final String CUSTOMCELL_TAG = "customCell";
    private static final String STYLE_NAME_ATTRIBUTE = "styleName";

    @Override
    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        ArrayList<RowContent> matrix = new ArrayList<RowContent>();
        this.parseRows(elem, fieldName, writer, matrix);
        Size size = this.getMatrixSize(matrix);
        if (size.getRows() > 0 || size.getColumns() > 0) {
            writer.addStatement("%s.resize(%s, %s);", new Object[]{fieldName, Integer.toString(size.getRows()), Integer.toString(size.getColumns())});
            for (RowContent row : matrix) {
                if (row.getStyleName() != null && !row.getStyleName().isEmpty()) {
                    writer.addStatement("%s.getRowFormatter().setStyleName(%s, %s);", new Object[]{fieldName, matrix.indexOf(row), row.getStyleName()});
                }
                for (CellContent column : row.getColumns()) {
                    if (column.getTagName().equals(CELL_TAG)) {
                        writer.addStatement("%s.setHTML(%s, %s, %s);", new Object[]{fieldName, Integer.toString(matrix.indexOf(row)), Integer.toString(row.getColumns().indexOf(column)), writer.declareTemplateCall(column.getContent(), fieldName)});
                    }
                    if (column.getTagName().equals(CUSTOMCELL_TAG)) {
                        writer.addStatement("%s.setWidget(%s, %s, %s);", new Object[]{fieldName, Integer.toString(matrix.indexOf(row)), Integer.toString(row.getColumns().indexOf(column)), column.getContent()});
                    }
                    if (column.getStyleName() == null || column.getStyleName().isEmpty()) continue;
                    writer.addStatement("%s.getCellFormatter().setStyleName(%s, %s, %s);", new Object[]{fieldName, matrix.indexOf(row), row.getColumns().indexOf(column), column.getStyleName()});
                }
            }
        }
    }

    private Size getMatrixSize(List<RowContent> matrix) {
        int maxColumns = 0;
        for (RowContent row : matrix) {
            maxColumns = row.getColumns().size() > maxColumns ? row.getColumns().size() : maxColumns;
        }
        return new Size(matrix.size(), maxColumns);
    }

    private void parseColumns(String fieldName, UiBinderWriter writer, RowContent row, XMLElement child) throws UnableToCompleteException {
        for (XMLElement cell : child.consumeChildElements()) {
            String tagName = cell.getLocalName();
            if (!tagName.equals(CELL_TAG) && !tagName.equals(CUSTOMCELL_TAG) || !cell.getPrefix().equals(child.getPrefix())) {
                writer.die("Grid's row tag in %s may only contain %s or %s element.", new Object[]{fieldName, CELL_TAG, CUSTOMCELL_TAG});
            }
            CellContent newColumn = null;
            String styleName = cell.consumeStringAttribute(STYLE_NAME_ATTRIBUTE, null);
            if (tagName.equals(CELL_TAG)) {
                HtmlInterpreter htmlInt = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName);
                String html = cell.consumeInnerHtml((XMLElement.Interpreter)htmlInt);
                newColumn = new CellContent(tagName, html, styleName);
            }
            if (tagName.equals(CUSTOMCELL_TAG)) {
                FieldWriter field = writer.parseElementToField(cell.consumeSingleChildElement());
                newColumn = new CellContent(tagName, field.getNextReference(), styleName);
            }
            row.addColumn(newColumn);
        }
    }

    private void parseRows(XMLElement elem, String fieldName, UiBinderWriter writer, List<RowContent> matrix) throws UnableToCompleteException {
        for (XMLElement child : elem.consumeChildElements()) {
            String tagName = child.getLocalName();
            if (!tagName.equals(ROW_TAG) || !elem.getPrefix().equals(child.getPrefix())) {
                writer.die("%1$s:Grid elements must contain only %1$s:%2$s children, found %3$s:%4$s", new Object[]{elem.getPrefix(), ROW_TAG, child.getPrefix(), tagName});
            }
            RowContent newRow = new RowContent();
            newRow.setStyleName(child.consumeStringAttribute(STYLE_NAME_ATTRIBUTE, null));
            matrix.add(newRow);
            this.parseColumns(fieldName, writer, newRow, child);
        }
    }

    private static class Size {
        private int rows;
        private int columns;

        public Size(int rows, int columns) {
            this.rows = rows;
            this.columns = columns;
        }

        public int getColumns() {
            return this.columns;
        }

        public int getRows() {
            return this.rows;
        }
    }

    private static class RowContent {
        private List<CellContent> columns = new ArrayList<CellContent>();
        private String styleName;

        private RowContent() {
        }

        private void addColumn(CellContent column) {
            this.columns.add(column);
        }

        public List<CellContent> getColumns() {
            return this.columns;
        }

        public String getStyleName() {
            return this.styleName;
        }

        public void setStyleName(String styleName) {
            this.styleName = styleName;
        }
    }

    private static class CellContent {
        private String tagName;
        private String content;
        private String styleName;

        public CellContent(String tagName, String content, String styleName) {
            this.tagName = tagName;
            this.content = content;
            this.styleName = styleName;
        }

        public String getContent() {
            return this.content;
        }

        public String getStyleName() {
            return this.styleName;
        }

        public String getTagName() {
            return this.tagName;
        }
    }
}

