/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server;

import com.google.gwt.i18n.client.LocalizableResource;
import com.google.gwt.i18n.server.Message;
import com.google.gwt.i18n.server.MessageInterface;
import com.google.gwt.i18n.server.MessageInterfaceVisitor;
import com.google.gwt.i18n.server.MessageProcessingException;
import com.google.gwt.i18n.server.MessageTranslation;
import com.google.gwt.i18n.server.MessageVisitor;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.i18n.shared.GwtLocaleFactory;
import java.lang.annotation.Annotation;
import java.util.Iterator;

public abstract class AbstractMessageInterface
implements MessageInterface {
    protected final GwtLocaleFactory factory;

    public AbstractMessageInterface(GwtLocaleFactory factory) {
        this.factory = factory;
    }

    @Override
    public void accept(MessageInterfaceVisitor cv) throws MessageProcessingException {
        this.accept(cv, this.factory.getDefault());
    }

    @Override
    public void accept(MessageInterfaceVisitor cv, GwtLocale locale) throws MessageProcessingException {
        GwtLocale sourceLocale;
        String defaultLocale = "en";
        LocalizableResource.DefaultLocale defLocaleAnnot = this.getAnnotation(LocalizableResource.DefaultLocale.class);
        if (defLocaleAnnot != null) {
            defaultLocale = defLocaleAnnot.value();
        }
        try {
            sourceLocale = this.factory.fromString(defaultLocale);
        }
        catch (IllegalArgumentException e) {
            sourceLocale = this.factory.fromString("en");
        }
        cv.visitMessageInterface(this, sourceLocale);
        Iterator<Message> iterator = this.getMessages().iterator();
        while (iterator.hasNext()) {
            Message msg;
            MessageTranslation trans = (msg = iterator.next()).getTranslation(locale);
            MessageVisitor mv = cv.visitMessage(msg, trans != null ? trans : msg);
            if (mv == null) continue;
            msg.accept(mv);
        }
        cv.endMessageInterface(this);
    }

    @Override
    public abstract <A extends Annotation> A getAnnotation(Class<A> var1);

    @Override
    public abstract String getClassName();

    public abstract Iterable<Message> getMessages() throws MessageProcessingException;

    @Override
    public abstract String getPackageName();

    @Override
    public abstract String getQualifiedName();

    @Override
    public abstract boolean isAnnotationPresent(Class<? extends Annotation> var1);

    public String toString() {
        return this.getClassName();
    }
}

