/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.util.concurrent.CountDownLatch;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;

public class SleepWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    protected long durationMillis;
    protected String category;
    protected static transient boolean debug;
    protected static CountDownLatch readyLatch;
    protected static CountDownLatch doneLatch;
    protected static CountDownLatch startLatch;
    protected static CountDownLatch finishLatch;

    public SleepWork(long durationMillis) {
        this(durationMillis, "SleepWork", false);
    }

    public SleepWork(long durationMillis, boolean debug) {
        this(durationMillis, "SleepWork", debug);
    }

    public SleepWork(long durationMillis, boolean debug, String id) {
        this(durationMillis, "SleepWork", debug, id);
    }

    public SleepWork(long durationMillis, String category, boolean debug) {
        this.init(durationMillis, category, debug);
    }

    public SleepWork(long durationMillis, String category, boolean debug, String id) {
        super(id);
        this.init(durationMillis, category, debug);
    }

    private void init(long durationMillis, String category, boolean debug) {
        this.durationMillis = durationMillis;
        this.category = category;
        SleepWork.debug = debug;
        this.setProgress(Work.Progress.PROGRESS_0_PC);
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getTitle() {
        return "Sleep " + this.durationMillis + " ms";
    }

    @Override
    public void work() {
        try {
            this.doWork();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected void doWork() throws InterruptedException {
        long elapsed;
        if (debug) {
            this.setStatus("Starting sleep work");
            readyLatch.countDown();
            startLatch.await();
            this.setStatus("Running sleep work");
        }
        while ((elapsed = System.currentTimeMillis() - this.getStartTime()) <= this.durationMillis) {
            this.setProgress(new Work.Progress(100.0f * (float)elapsed / (float)this.durationMillis));
            if (this.isSuspending()) {
                this.durationMillis -= elapsed;
                this.suspended();
                if (debug) {
                    doneLatch.countDown();
                    finishLatch.await();
                }
                return;
            }
            Thread.sleep(10L);
        }
        if (debug) {
            this.setStatus("Completed sleep work");
            this.setProgress(Work.Progress.PROGRESS_100_PC);
            doneLatch.countDown();
            finishLatch.await();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + (this.getId().length() > 10 ? "" : this.getId() + ", ") + this.durationMillis + "ms, " + this.getProgress() + ")";
    }

    public void debugWaitReady() throws InterruptedException {
        readyLatch.await();
    }

    public void debugWaitDone() throws InterruptedException {
        doneLatch.await();
    }

    public void debugStart() {
        startLatch.countDown();
    }

    public void debugFinish() {
        finishLatch.countDown();
    }

    static {
        readyLatch = new CountDownLatch(1);
        doneLatch = new CountDownLatch(1);
        startLatch = new CountDownLatch(1);
        finishLatch = new CountDownLatch(1);
    }
}

