/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DataModelMap;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyVisitor;
import org.nuxeo.ecm.core.api.model.resolver.DocumentPropertyObjectResolverImpl;
import org.nuxeo.ecm.core.api.model.resolver.PropertyObjectResolver;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.schema.DocumentType;

public class ShallowDocumentModel
implements DocumentModel {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String repoName;
    private final String name;
    private final Path path;
    private final String type;
    private final boolean isFolder;
    private final boolean isVersion;
    private final boolean isProxy;
    private final boolean isImmutable;
    private final ScopedMap contextData;
    private final Set<String> facets;
    private final String lifecycleState;

    public ShallowDocumentModel(DocumentModel doc) {
        this.id = doc.getId();
        this.repoName = doc.getRepositoryName();
        this.name = doc.getName();
        this.path = doc.getPath();
        this.type = doc.getType();
        this.isFolder = doc.isFolder();
        this.isVersion = doc.isVersion();
        this.isProxy = doc.isProxy();
        this.isImmutable = doc.isImmutable();
        this.contextData = doc.getContextData();
        this.facets = doc.getFacets();
        this.lifecycleState = doc.isLifeCycleLoaded() ? doc.getCurrentLifeCycleState() : null;
    }

    public String getId() {
        return this.id;
    }

    public DocumentRef getRef() {
        return this.id == null ? null : new IdRef(this.id);
    }

    public String getRepositoryName() {
        return this.repoName;
    }

    public String getName() {
        return this.name;
    }

    public Long getPos() {
        return null;
    }

    public Path getPath() {
        return this.path;
    }

    public String getPathAsString() {
        if (this.path != null) {
            return this.path.toString();
        }
        return null;
    }

    public DocumentRef getParentRef() {
        if (this.path != null) {
            return new PathRef(this.path.removeLastSegments(1).toString());
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public boolean isVersion() {
        return this.isVersion;
    }

    public void copyContent(DocumentModel sourceDoc) {
        throw new UnsupportedOperationException();
    }

    public void copyContextData(DocumentModel otherDocument) {
        throw new UnsupportedOperationException();
    }

    public boolean followTransition(String transition) {
        throw new UnsupportedOperationException();
    }

    public ACP getACP() {
        throw new UnsupportedOperationException();
    }

    public void accept(PropertyVisitor visitor, Object arg) {
        throw new UnsupportedOperationException();
    }

    public <T> T getAdapter(Class<T> itf) {
        throw new UnsupportedOperationException();
    }

    public <T> T getAdapter(Class<T> itf, boolean refreshCache) {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getAllowedStateTransitions() {
        throw new UnsupportedOperationException();
    }

    public String getCacheKey() {
        throw new UnsupportedOperationException();
    }

    public ScopedMap getContextData() {
        return this.contextData;
    }

    public Serializable getContextData(ScopeType scope, String key) {
        if (this.contextData == null) {
            return null;
        }
        return this.contextData.getScopedValue(scope, key);
    }

    public CoreSession getCoreSession() {
        throw new UnsupportedOperationException();
    }

    public void detach(boolean loadAll) {
    }

    public void attach(String sid) {
    }

    public String getCurrentLifeCycleState() {
        return this.lifecycleState;
    }

    public DataModel getDataModel(String schema) {
        throw new UnsupportedOperationException();
    }

    public DataModelMap getDataModels() {
        throw new UnsupportedOperationException();
    }

    public Collection<DataModel> getDataModelsCollection() {
        throw new UnsupportedOperationException();
    }

    public Set<String> getFacets() {
        return this.facets;
    }

    public Set<String> getDeclaredFacets() {
        throw new UnsupportedOperationException();
    }

    public String[] getSchemas() {
        throw new UnsupportedOperationException();
    }

    public String[] getDeclaredSchemas() {
        throw new UnsupportedOperationException();
    }

    public DocumentType getDocumentType() {
        throw new UnsupportedOperationException();
    }

    public String getLifeCyclePolicy() {
        throw new UnsupportedOperationException();
    }

    public String getLock() {
        throw new UnsupportedOperationException();
    }

    public DocumentPart getPart(String schema) {
        throw new UnsupportedOperationException();
    }

    public DocumentPart[] getParts() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getProperties(String schemaName) {
        throw new UnsupportedOperationException();
    }

    public Property getProperty(String xpath) throws PropertyException {
        throw new UnsupportedOperationException();
    }

    public Object getProperty(String schemaName, String name) {
        throw new UnsupportedOperationException();
    }

    public Serializable getPropertyValue(String xpath) throws PropertyException {
        throw new UnsupportedOperationException();
    }

    public String getSessionId() {
        throw new UnsupportedOperationException();
    }

    public String getSourceId() {
        throw new UnsupportedOperationException();
    }

    public <T extends Serializable> T getSystemProp(String systemProperty, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public String getTitle() {
        throw new UnsupportedOperationException();
    }

    public String getVersionLabel() {
        throw new UnsupportedOperationException();
    }

    public String getCheckinComment() {
        throw new UnsupportedOperationException();
    }

    public boolean hasFacet(String facet) {
        return this.facets.contains(facet);
    }

    public boolean hasSchema(String schema) {
        throw new UnsupportedOperationException();
    }

    public boolean addFacet(String facet) {
        throw new UnsupportedOperationException();
    }

    public boolean removeFacet(String facet) {
        throw new UnsupportedOperationException();
    }

    public boolean isDownloadable() {
        throw new UnsupportedOperationException();
    }

    public boolean isLifeCycleLoaded() {
        return this.lifecycleState != null;
    }

    public boolean isLocked() {
        throw new UnsupportedOperationException();
    }

    public boolean isProxy() {
        return this.isProxy;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public boolean isDirty() {
        throw new UnsupportedOperationException();
    }

    public boolean isVersionable() {
        throw new UnsupportedOperationException();
    }

    public boolean isPrefetched(String xpath) {
        return false;
    }

    public boolean isPrefetched(String schemaName, String name) {
        return false;
    }

    public void prefetchCurrentLifecycleState(String lifecycle) {
        throw new UnsupportedOperationException();
    }

    public void prefetchLifeCyclePolicy(String lifeCyclePolicy) {
        throw new UnsupportedOperationException();
    }

    public void putContextData(String key, Serializable value) {
        throw new UnsupportedOperationException();
    }

    public void putContextData(ScopeType scope, String key, Serializable value) {
        throw new UnsupportedOperationException();
    }

    public void refresh() {
        throw new UnsupportedOperationException();
    }

    public void refresh(int refreshFlags, String[] schemas) {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void setACP(ACP acp, boolean overwrite) {
        throw new UnsupportedOperationException();
    }

    public void setLock(String key) {
        throw new UnsupportedOperationException();
    }

    public Lock setLock() {
        throw new UnsupportedOperationException();
    }

    public Lock getLockInfo() {
        throw new UnsupportedOperationException();
    }

    public Lock removeLock() {
        throw new UnsupportedOperationException();
    }

    public void setPathInfo(String parentPath, String name) {
        throw new UnsupportedOperationException();
    }

    public void setProperties(String schemaName, Map<String, Object> data) {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String schemaName, String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public void setPropertyValue(String xpath, Serializable value) {
        throw new UnsupportedOperationException();
    }

    public void unlock() {
        throw new UnsupportedOperationException();
    }

    public DocumentModel clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public Serializable getContextData(String key) {
        if (this.contextData == null) {
            return null;
        }
        return this.contextData.getScopedValue(key);
    }

    public boolean isCheckedOut() {
        throw new UnsupportedOperationException();
    }

    public void checkOut() {
        throw new UnsupportedOperationException();
    }

    public DocumentRef checkIn(VersioningOption option, String checkinComment) {
        throw new UnsupportedOperationException();
    }

    public String getVersionSeriesId() {
        throw new UnsupportedOperationException();
    }

    public boolean isLatestVersion() {
        return false;
    }

    public boolean isMajorVersion() {
        return false;
    }

    public boolean isLatestMajorVersion() {
        return false;
    }

    public boolean isVersionSeriesCheckedOut() {
        return true;
    }

    public String getChangeToken() {
        return null;
    }

    public Map<String, String> getBinaryFulltext() {
        return null;
    }

    public PropertyObjectResolver getObjectResolver(String xpath) {
        return DocumentPropertyObjectResolverImpl.create((DocumentModel)this, (String)xpath);
    }
}

