/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.computedgroups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.platform.computedgroups.ComputedGroupsService;
import org.nuxeo.ecm.platform.computedgroups.GroupComputer;
import org.nuxeo.ecm.platform.computedgroups.GroupComputerChainDescriptor;
import org.nuxeo.ecm.platform.computedgroups.GroupComputerDescriptor;
import org.nuxeo.ecm.platform.computedgroups.GroupComputerLabelled;
import org.nuxeo.ecm.platform.computedgroups.NuxeoComputedGroup;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ComputedGroupsServiceImpl
extends DefaultComponent
implements ComputedGroupsService {
    public static final String COMPUTER_EP = "computer";
    public static final String CHAIN_EP = "computerChain";
    protected static Map<String, GroupComputerDescriptor> computers = new HashMap<String, GroupComputerDescriptor>();
    protected static List<String> computerNames = new ArrayList<String>();
    protected boolean allowOverride = true;
    protected static Log log = LogFactory.getLog(ComputedGroupsServiceImpl.class);

    public void activate(ComponentContext context) {
        super.activate(context);
        computers = new HashMap<String, GroupComputerDescriptor>();
        computerNames = new ArrayList<String>();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (COMPUTER_EP.equals(extensionPoint)) {
            if (contribution instanceof GroupComputerDescriptor) {
                GroupComputerDescriptor desc = (GroupComputerDescriptor)contribution;
                if (desc.isEnabled()) {
                    log.debug((Object)("Add " + desc.getName() + " from component " + contributor.getName()));
                    computers.put(desc.getName(), desc);
                } else if (computers.containsKey(desc.getName())) {
                    log.debug((Object)("Remove " + desc.getName() + " from component " + contributor.getName()));
                    computers.remove(desc.getName());
                } else {
                    log.warn((Object)("Can't remove " + desc.getName() + " as not found, from component " + contributor.getName()));
                }
                return;
            }
            throw new RuntimeException("Waiting GroupComputerDescriptor contribution kind, please look component " + contributor.getName());
        }
        if (CHAIN_EP.equals(extensionPoint)) {
            GroupComputerChainDescriptor desc = (GroupComputerChainDescriptor)contribution;
            if (desc.isAppend()) {
                computerNames.addAll(desc.getComputerNames());
            } else {
                computerNames = desc.getComputerNames();
            }
            return;
        }
        log.warn((Object)("Unkown contribution, please check the component " + contributor.getName()));
    }

    @Override
    public List<String> computeGroupsForUser(NuxeoPrincipalImpl nuxeoPrincipal) {
        ArrayList<String> userGroups = new ArrayList<String>();
        for (String computerName : computerNames) {
            userGroups.addAll(computers.get(computerName).getComputer().getGroupsForUser(nuxeoPrincipal));
        }
        return userGroups;
    }

    @Override
    public void updateGroupsForUser(NuxeoPrincipalImpl nuxeoPrincipal) {
        List<String> computedGroups = this.computeGroupsForUser(nuxeoPrincipal);
        HashSet<String> virtualGroups = new HashSet<String>(nuxeoPrincipal.getVirtualGroups());
        virtualGroups.addAll(computedGroups);
        nuxeoPrincipal.setVirtualGroups(new ArrayList(virtualGroups));
    }

    @Override
    public boolean allowGroupOverride() {
        return this.allowOverride;
    }

    @Override
    public NuxeoGroup getComputedGroup(String groupName) {
        for (String name : computerNames) {
            GroupComputer computer = computers.get(name).getComputer();
            if (!computer.hasGroup(groupName)) continue;
            if (computer instanceof GroupComputerLabelled) {
                String groupLabel = ((GroupComputerLabelled)computer).getLabel(groupName);
                return new NuxeoComputedGroup(groupName, groupLabel);
            }
            return new NuxeoComputedGroup(groupName);
        }
        return null;
    }

    @Override
    public List<String> computeGroupIds() {
        ArrayList<String> groupIds = new ArrayList<String>();
        for (String name : computerNames) {
            GroupComputerDescriptor desc = computers.get(name);
            List<String> foundGroupIds = desc.getComputer().getAllGroupIds();
            if (foundGroupIds == null) continue;
            groupIds.addAll(foundGroupIds);
        }
        return groupIds;
    }

    @Override
    public List<String> getComputedGroupMembers(String groupName) {
        ArrayList<String> members = new ArrayList<String>();
        for (String name : computerNames) {
            GroupComputerDescriptor desc = computers.get(name);
            List<String> foundMembers = desc.getComputer().getGroupMembers(groupName);
            if (foundMembers == null) continue;
            members.addAll(foundMembers);
        }
        return members;
    }

    @Override
    public List<String> getComputedGroupParent(String groupName) {
        ArrayList<String> parents = new ArrayList<String>();
        for (String name : computerNames) {
            GroupComputerDescriptor desc = computers.get(name);
            List<String> foundParents = desc.getComputer().getParentsGroupNames(groupName);
            if (foundParents == null) continue;
            parents.addAll(foundParents);
        }
        return parents;
    }

    @Override
    public List<String> getComputedGroupSubGroups(String groupName) {
        ArrayList<String> subGroups = new ArrayList<String>();
        for (String name : computerNames) {
            GroupComputerDescriptor desc = computers.get(name);
            List<String> foundSubGroups = desc.getComputer().getSubGroupsNames(groupName);
            if (foundSubGroups == null) continue;
            subGroups.addAll(foundSubGroups);
        }
        return subGroups;
    }

    public List<GroupComputerDescriptor> getComputerDescriptors() {
        ArrayList<GroupComputerDescriptor> result = new ArrayList<GroupComputerDescriptor>();
        for (String name : computerNames) {
            result.add(computers.get(name));
        }
        return result;
    }

    @Override
    public boolean activateComputedGroups() {
        return computerNames.size() > 0;
    }

    @Override
    public List<String> searchComputedGroups(Map<String, Serializable> filter, Set<String> fulltext) {
        ArrayList<String> foundGroups = new ArrayList<String>();
        for (String name : computerNames) {
            GroupComputerDescriptor desc = computers.get(name);
            foundGroups.addAll(desc.getComputer().searchGroups(filter, fulltext));
        }
        Collections.sort(foundGroups);
        return foundGroups;
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }
}

