/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.webengine;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.runtime.api.Framework;

public class RedirectHelper {
    private static final Log log = LogFactory.getLog(RedirectHelper.class);

    public static String getJSFDocumentPath(DocumentModel doc, String baseUrl) {
        DocumentViewImpl view = new DocumentViewImpl(doc);
        return RedirectHelper.getCodecManager().getUrlFromDocumentView((DocumentView)view, true, baseUrl);
    }

    public static DocumentRef findDocumentRef(String targetURL) {
        if (StringUtils.isBlank((String)targetURL)) {
            log.debug((Object)"TargetURL is empty");
            return null;
        }
        DocumentView docView = RedirectHelper.getCodecManager().getDocumentViewFromUrl(targetURL, true, "");
        if (docView == null) {
            log.info((Object)("Unable to resolve docView for targetURL: " + targetURL));
            return null;
        }
        PathRef docPathRef = docView.getDocumentLocation().getPathRef();
        if (docPathRef != null && docPathRef.equals((Object)new PathRef("/"))) {
            log.debug((Object)"Trying to access root document using targetUrl");
            return null;
        }
        return docView.getDocumentLocation().getDocRef();
    }

    protected static DocumentViewCodecManager getCodecManager() {
        return (DocumentViewCodecManager)Framework.getLocalService(DocumentViewCodecManager.class);
    }
}

