/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.rules;

import java.util.Arrays;
import java.util.HashSet;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.publisher.rules.ValidatorsRule;

public class DefaultValidatorsRule
implements ValidatorsRule {
    private static final long serialVersionUID = 1L;

    public String[] computesValidatorsFor(DocumentModel doc) {
        UnrestrictedACPGetter acpg = new UnrestrictedACPGetter(doc);
        acpg.runUnrestricted();
        String[] writePermissions = doc.getCoreSession().getPermissionsToCheck("Write");
        String[] reviewers = acpg.acp.listUsernamesForAnyPermission(new HashSet<String>(Arrays.asList(writePermissions)));
        return reviewers;
    }

    protected static class UnrestrictedACPGetter
    extends UnrestrictedSessionRunner {
        public final DocumentRef docRef;
        public ACP acp;

        public UnrestrictedACPGetter(DocumentModel doc) {
            super(doc.getCoreSession());
            this.docRef = doc.getRef();
        }

        public void run() {
            this.acp = this.session.getACP(this.docRef);
        }
    }
}

