/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.marshaling;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.AbstractDefaultXMLMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.basic.BasicPublicationNode;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.interfaces.PublicationNodeMarshaler;

public class DefaultPublicationNodeMarshaler
extends AbstractDefaultXMLMarshaler
implements PublicationNodeMarshaler {
    protected static QName rootTag = DocumentFactory.getInstance().createQName("publicationNode", "nxpub", "http://www.nuxeo.org/publisher");
    protected static QName nodePathTag = DocumentFactory.getInstance().createQName("nodePath", "nxpub", "http://www.nuxeo.org/publisher");
    protected static QName nodeTitleTag = DocumentFactory.getInstance().createQName("nodeTile", "nxpub", "http://www.nuxeo.org/publisher");
    protected static QName nodeTypeTag = DocumentFactory.getInstance().createQName("nodeType", "nxpub", "http://www.nuxeo.org/publisher");
    protected static QName treeNameTag = DocumentFactory.getInstance().createQName("treeName", "nxpub", "http://www.nuxeo.org/publisher");
    protected static QName sidTag = DocumentFactory.getInstance().createQName("sid", "nxpub", "http://www.nuxeo.org/publisher");

    public String marshalPublicationNode(PublicationNode node) {
        Element rootElem = DocumentFactory.getInstance().createElement(rootTag);
        rootElem.addNamespace("nxpub", "http://www.nuxeo.org/publisher");
        Document rootDoc = DocumentFactory.getInstance().createDocument(rootElem);
        Element pathElem = rootElem.addElement(nodePathTag);
        pathElem.setText(node.getPath());
        Element titleElem = rootElem.addElement(nodeTitleTag);
        titleElem.setText(node.getTitle());
        Element typeElem = rootElem.addElement(nodeTypeTag);
        typeElem.setText(node.getNodeType());
        Element treeElem = rootElem.addElement(treeNameTag);
        treeElem.setText(node.getTreeConfigName());
        Element sidElem = rootElem.addElement(sidTag);
        if (node.getSessionId() != null) {
            sidElem.setText(node.getSessionId());
        } else {
            sidElem.setText("");
        }
        String data = rootDoc.asXML();
        return this.cleanUpXml(data);
    }

    public PublicationNode unMarshalPublicationNode(String data) {
        BasicPublicationNode node = null;
        try {
            Document document = DocumentHelper.parseText((String)data);
            Element rootElem = document.getRootElement();
            String nodePath = rootElem.element(nodePathTag).getTextTrim();
            String nodeTitle = rootElem.element(nodeTitleTag).getTextTrim();
            String nodeType = rootElem.element(nodeTypeTag).getTextTrim();
            String treeName = rootElem.element(treeNameTag).getTextTrim();
            String sid = rootElem.element(sidTag).getTextTrim();
            node = new BasicPublicationNode(nodeType, nodePath, nodeTitle, treeName, sid);
        }
        catch (DocumentException e) {
            throw new NuxeoException("Unable to unmarshal Piublication Node", (Throwable)e);
        }
        return node;
    }
}

