/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.RemotePublicationTreeManager;

public abstract class AbstractRemotableTree
implements PublicationTree {
    private static final Log log = LogFactory.getLog(AbstractRemotableTree.class);
    protected RemotePublicationTreeManager treeService;
    protected String sessionId;
    protected String configName;
    protected boolean released = false;

    protected abstract RemotePublicationTreeManager getTreeService();

    protected abstract String getTargetTreeName();

    protected abstract String getServerTreeSessionId();

    public List<PublishedDocument> getExistingPublishedDocument(DocumentLocation docLoc) {
        return this.getTreeService().getExistingPublishedDocument(this.getServerTreeSessionId(), docLoc);
    }

    public List<PublishedDocument> getPublishedDocumentInNode(PublicationNode node) {
        return this.getTreeService().getPublishedDocumentInNode(this.switchToServerNode(node));
    }

    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode) {
        return this.publish(doc, targetNode, null);
    }

    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) {
        return this.getTreeService().publish(doc, this.switchToServerNode(targetNode), params);
    }

    public void unpublish(DocumentModel doc, PublicationNode targetNode) {
        this.getTreeService().unpublish(doc, this.switchToServerNode(targetNode));
    }

    public void unpublish(PublishedDocument publishedDocument) {
        this.getTreeService().unpublish(this.getServerTreeSessionId(), publishedDocument);
    }

    protected abstract PublicationNode switchToClientNode(PublicationNode var1);

    protected abstract PublicationNode switchToServerNode(PublicationNode var1);

    protected List<PublicationNode> switchToClientNodes(List<PublicationNode> nodes) {
        ArrayList<PublicationNode> wrappedNodes = new ArrayList<PublicationNode>();
        for (PublicationNode node : nodes) {
            wrappedNodes.add(this.switchToClientNode(node));
        }
        return wrappedNodes;
    }

    public PublicationNode getNodeByPath(String path) {
        return this.switchToClientNode(this.getTreeService().getNodeByPath(this.getServerTreeSessionId(), path));
    }

    public String getConfigName() {
        return this.configName;
    }

    public PublicationNode getParent() {
        return null;
    }

    public void setCurrentDocument(DocumentModel currentDocument) {
        this.getTreeService().setCurrentDocument(this.getServerTreeSessionId(), currentDocument);
    }

    public void release() {
        if (!this.released) {
            this.getTreeService().release(this.getServerTreeSessionId());
        }
        this.released = true;
    }

    public void validatorPublishDocument(PublishedDocument publishedDocument, String comment) {
        this.getTreeService().validatorPublishDocument(this.getServerTreeSessionId(), publishedDocument, comment);
    }

    public void validatorRejectPublication(PublishedDocument publishedDocument, String comment) {
        this.getTreeService().validatorRejectPublication(this.getServerTreeSessionId(), publishedDocument, comment);
    }

    public boolean canPublishTo(PublicationNode publicationNode) {
        return this.getTreeService().canPublishTo(this.getServerTreeSessionId(), publicationNode);
    }

    public boolean canUnpublish(PublishedDocument publishedDocument) {
        return this.getTreeService().canUnpublish(this.getServerTreeSessionId(), publishedDocument);
    }

    public boolean hasValidationTask(PublishedDocument publishedDocument) {
        return this.getTreeService().hasValidationTask(this.getServerTreeSessionId(), publishedDocument);
    }

    public boolean canManagePublishing(PublishedDocument publishedDocument) {
        return this.getTreeService().canManagePublishing(this.getServerTreeSessionId(), publishedDocument);
    }

    public PublishedDocument wrapToPublishedDocument(DocumentModel documentModel) {
        return this.getTreeService().wrapToPublishedDocument(this.getServerTreeSessionId(), documentModel);
    }

    public boolean isPublicationNode(DocumentModel documentModel) {
        return this.getTreeService().isPublicationNode(this.getServerTreeSessionId(), documentModel);
    }

    public PublicationNode wrapToPublicationNode(DocumentModel documentModel) {
        return this.getTreeService().wrapToPublicationNode(this.getServerTreeSessionId(), documentModel);
    }
}

