/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.workflow;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.task.CreateTask;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.comment.workflow.utils.FollowTransitionUnrestricted;
import org.nuxeo.ecm.platform.task.Task;

@Operation(id="Comment.Moderate", category="Document", label="Follow publish or reject transition", description="Follow publish if accept is true, reject otherwise.", addToStudio=false)
public class ModerateCommentOperation {
    public static final String ID = "Comment.Moderate";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Param(name="accept")
    protected Boolean accept;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        this.moderate(doc.getRef());
        return doc;
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef docRef) {
        this.moderate(docRef);
        return this.session.getDocument(docRef);
    }

    protected void moderate(DocumentRef docRef) {
        DocumentModel taskDoc = (DocumentModel)this.ctx.get((Object)CreateTask.OperationTaskVariableName.taskDocument.name());
        Task task = (Task)taskDoc.getAdapter(Task.class);
        IdRef targetDocRef = new IdRef(task.getVariable("commentId"));
        FollowTransitionUnrestricted runner = this.accept != false ? new FollowTransitionUnrestricted(this.session, (DocumentRef)targetDocRef, "moderation_publish") : new FollowTransitionUnrestricted(this.session, (DocumentRef)targetDocRef, "moderation_reject");
        runner.runUnrestricted();
    }
}

