/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.log4j;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class IoLog4jFilter
extends Filter {
    protected static String nuxeoUrl;
    protected static final Pattern REGEX;

    public int decide(LoggingEvent event) {
        event.setProperty("nuxeo_url", this.getNuxeoUrl());
        return 0;
    }

    protected String getNuxeoUrl() {
        if (nuxeoUrl == null) {
            try {
                FileSystem fs = FileSystems.getDefault();
                Path path = fs.getPath("./bin/nuxeo.conf", new String[0]);
                nuxeoUrl = IoLog4jFilter.findNuxeoUrl(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return nuxeoUrl;
    }

    public static String findNuxeoUrl(Path path) throws IOException {
        String lastMatch = "";
        for (String line : Files.readAllLines(path)) {
            if (!IoLog4jFilter.isNuxeoUrlLine(line)) continue;
            lastMatch = line.split("=")[1].trim();
        }
        return lastMatch;
    }

    public static boolean isNuxeoUrlLine(String line) {
        return REGEX.matcher(line).matches();
    }

    static {
        REGEX = Pattern.compile("nuxeo\\.url=.+");
    }
}

