/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals.operation;

import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import org.nuxeo.automation.scripting.internals.ScriptOperationContext;
import org.nuxeo.automation.scripting.internals.operation.ScriptingOperationDescriptor;
import org.nuxeo.automation.scripting.internals.operation.ScriptingOperationImpl;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.impl.OperationTypeImpl;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentRefList;
import org.nuxeo.ecm.core.api.NuxeoException;

public class ScriptingOperationTypeImpl
extends OperationTypeImpl {
    protected final AutomationService service;
    protected final ScriptingOperationDescriptor desc;
    protected final InvokableMethod[] methods;

    public ScriptingOperationTypeImpl(AutomationService service, ScriptingOperationDescriptor desc) {
        this.service = service;
        this.desc = desc;
        this.inputType = desc.getInputType();
        this.methods = new InvokableMethod[]{this.runMethod()};
    }

    public String getContributingComponent() {
        return null;
    }

    public OperationDocumentation getDocumentation() {
        OperationDocumentation doc = new OperationDocumentation(this.getId());
        doc.label = this.getId();
        doc.category = this.desc.getCategory();
        doc.description = this.desc.getDescription();
        doc.params = this.desc.getParams();
        doc.signature = new String[]{this.desc.getInputType(), this.desc.getOutputType()};
        doc.aliases = this.desc.getAliases();
        return doc;
    }

    public String getId() {
        return this.desc.getId();
    }

    public String[] getAliases() {
        return this.desc.getAliases();
    }

    public List<InvokableMethod> getMethods() {
        return Arrays.asList(this.methods);
    }

    public InvokableMethod[] getMethodsMatchingInput(Class<?> in) {
        return this.methods;
    }

    public AutomationService getService() {
        return this.service;
    }

    public Class<?> getType() {
        return ScriptingOperationImpl.class;
    }

    public Object newInstance(OperationContext ctx, Map<String, Object> args) throws OperationException {
        ScriptingOperationImpl impl;
        if (ctx.getVars().containsKey("ChainParameters")) {
            args.putAll((Map)ctx.getVars().get("ChainParameters"));
        }
        ScriptOperationContext sctx = new ScriptOperationContext(ctx);
        try {
            impl = new ScriptingOperationImpl(this.desc.getScript(), sctx, args);
        }
        catch (ScriptException e) {
            throw new NuxeoException((Throwable)e);
        }
        return impl;
    }

    protected String getParamDocumentationType(Class<?> type, boolean isIterable) {
        String t = DocumentModel.class.isAssignableFrom(type) || DocumentRef.class.isAssignableFrom(type) ? (isIterable ? "documents" : "document") : (DocumentModelList.class.isAssignableFrom(type) || DocumentRefList.class.isAssignableFrom(type) ? "documents" : (BlobList.class.isAssignableFrom(type) ? "bloblist" : (Blob.class.isAssignableFrom(type) ? (isIterable ? "bloblist" : "blob") : (URL.class.isAssignableFrom(type) ? "resource" : (Calendar.class.isAssignableFrom(type) ? "date" : type.getSimpleName().toLowerCase())))));
        return t;
    }

    protected InvokableMethod runMethod() {
        try {
            return new InvokableMethod((OperationType)this, ScriptingOperationImpl.class.getMethod("run", Object.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new UnsupportedOperationException("Cannot use reflection for run method", e);
        }
    }
}

