/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals;

import javax.script.ScriptEngineManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.automation.scripting.api.AutomationScriptingService;
import org.nuxeo.automation.scripting.internals.AutomationScriptingServiceImpl;
import org.nuxeo.automation.scripting.internals.ScriptingFactory;
import org.nuxeo.automation.scripting.internals.operation.ScriptingOperationDescriptor;
import org.nuxeo.automation.scripting.internals.operation.ScriptingOperationTypeImpl;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.metrics.MetricInvocationHandler;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class AutomationScriptingComponent
extends DefaultComponent {
    private static final Log log = LogFactory.getLog(AutomationScriptingComponent.class);
    protected ScriptingFactory scriptingFactory;
    public AutomationScriptingService scriptingService = new AutomationScriptingServiceImpl();

    public void activate(ComponentContext context) {
        super.activate(context);
        this.scriptingFactory = new ScriptingFactory();
        this.scriptingFactory.install();
        if (Boolean.valueOf(Framework.getProperty((String)"automation.scripting.monitor.enable", (String)Boolean.toString(log.isTraceEnabled()))).booleanValue()) {
            this.scriptingService = (AutomationScriptingService)MetricInvocationHandler.newProxy((Object)this.scriptingService, (Class[])new Class[]{AutomationScriptingService.class});
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("operation".equals(extensionPoint)) {
            AutomationService automationService = (AutomationService)Framework.getLocalService(AutomationService.class);
            ScriptingOperationDescriptor desc = (ScriptingOperationDescriptor)contribution;
            ScriptingOperationTypeImpl type = new ScriptingOperationTypeImpl(automationService, desc);
            try {
                automationService.putOperation((OperationType)type, true);
            }
            catch (OperationException e) {
                throw new NuxeoException((Throwable)e);
            }
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("operation".equals(extensionPoint)) {
            AutomationService automationService = (AutomationService)Framework.getLocalService(AutomationService.class);
            ScriptingOperationDescriptor desc = (ScriptingOperationDescriptor)contribution;
            ScriptingOperationTypeImpl type = new ScriptingOperationTypeImpl(automationService, desc);
            automationService.removeOperation((OperationType)type);
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    public void applicationStarted(ComponentContext context) {
        super.applicationStarted(context);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(AutomationScriptingService.class)) {
            return adapter.cast(this.scriptingService);
        }
        if (adapter.isAssignableFrom(ScriptEngineManager.class)) {
            return adapter.cast(this.scriptingFactory.scriptEngineManager);
        }
        return null;
    }
}

