/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.nuxeo.automation.scripting.internals.MarshalingHelper;
import org.nuxeo.automation.scripting.internals.ScriptOperationContext;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.scripting.DocumentWrapper;
import org.nuxeo.ecm.automation.core.util.DataModelProperties;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.runtime.api.Framework;

public class AutomationMapper {
    protected final CoreSession session;
    public final ScriptOperationContext ctx;

    public AutomationMapper(CoreSession session, ScriptOperationContext operationContext) {
        this.session = session;
        this.ctx = operationContext;
    }

    public Object executeOperation(String opId, Object input, ScriptObjectMirror parameters) throws Exception {
        AutomationService automationService = (AutomationService)Framework.getService(AutomationService.class);
        this.unwrapContext(this.ctx, input);
        Map<String, Object> params = this.unwrapParameters(parameters);
        Object output = automationService.run((OperationContext)this.ctx, opId, params);
        return this.wrapContextAndOutput(output);
    }

    public void unwrapContext(ScriptOperationContext ctx, Object inputOutput) {
        if (inputOutput instanceof ScriptObjectMirror) {
            ctx.setInput(this.extractProperties((ScriptObjectMirror)inputOutput));
        } else if (inputOutput instanceof DocumentWrapper) {
            ctx.setInput(((DocumentWrapper)inputOutput).getDoc());
        } else if (inputOutput instanceof List) {
            DocumentModelListImpl docs = new DocumentModelListImpl();
            List l = (List)inputOutput;
            for (Object item : l) {
                if (!(item instanceof DocumentWrapper)) continue;
                docs.add((Object)((DocumentWrapper)item).getDoc());
            }
            if (docs.size() == l.size() && docs.size() > 0) {
                ctx.setInput(docs);
            }
        } else {
            ctx.setInput(inputOutput);
        }
        for (String entryId : ctx.keySet()) {
            Object entry = ctx.get(entryId);
            if (entry instanceof DocumentWrapper) {
                ctx.put(entryId, ((DocumentWrapper)entry).getDoc());
                continue;
            }
            if (!(ctx.get(entryId) instanceof List)) continue;
            DocumentModelListImpl docs = new DocumentModelListImpl();
            List l = (List)entry;
            for (Object item : l) {
                if (!(item instanceof DocumentWrapper)) continue;
                docs.add((Object)((DocumentWrapper)item).getDoc());
            }
            if (docs.size() != l.size() || docs.size() <= 0) continue;
            ctx.put(entryId, docs);
        }
    }

    protected Properties extractProperties(ScriptObjectMirror parameters) {
        DataModelProperties props = new DataModelProperties();
        Map<String, Object> data = MarshalingHelper.unwrapMap(parameters);
        for (String k : data.keySet()) {
            props.getMap().put(k, (Serializable)data.get(k));
        }
        return props;
    }

    protected Object wrapContextAndOutput(Object output) {
        for (String entryId : this.ctx.keySet()) {
            Object entry = this.ctx.get(entryId);
            if (entry instanceof DocumentModel) {
                this.ctx.put(entryId, new DocumentWrapper(this.ctx.getCoreSession(), (DocumentModel)entry));
            }
            if (!(entry instanceof DocumentModelList)) continue;
            ArrayList<DocumentWrapper> docs = new ArrayList<DocumentWrapper>();
            for (DocumentModel doc : (DocumentModelList)entry) {
                docs.add(new DocumentWrapper(this.ctx.getCoreSession(), doc));
            }
            this.ctx.put(entryId, docs);
        }
        if (output instanceof DocumentModel) {
            return new DocumentWrapper(this.ctx.getCoreSession(), (DocumentModel)output);
        }
        if (output instanceof DocumentModelList) {
            ArrayList<DocumentWrapper> docs = new ArrayList<DocumentWrapper>();
            for (DocumentModel doc : (DocumentModelList)output) {
                docs.add(new DocumentWrapper(this.ctx.getCoreSession(), doc));
            }
            return docs;
        }
        return output;
    }

    protected Map<String, Object> unwrapParameters(ScriptObjectMirror parameters) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (String k : parameters.keySet()) {
            Object value = parameters.get((Object)k);
            if (value instanceof ScriptObjectMirror) {
                ScriptObjectMirror jso = (ScriptObjectMirror)value;
                if (jso.isArray()) {
                    params.put(k, MarshalingHelper.unwrap(jso));
                    continue;
                }
                params.put(k, this.extractProperties(jso));
                continue;
            }
            if (value instanceof DocumentWrapper) {
                params.put(k, ((DocumentWrapper)value).getDoc());
                continue;
            }
            if (value instanceof List) {
                DocumentModelListImpl docs = new DocumentModelListImpl();
                List l = (List)value;
                for (Object item : l) {
                    if (!(item instanceof DocumentWrapper)) continue;
                    docs.add((Object)((DocumentWrapper)item).getDoc());
                }
                if (docs.size() != l.size() || docs.size() <= 0) continue;
                params.put(k, docs);
                continue;
            }
            params.put(k, value);
        }
        return params;
    }
}

