/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.service;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;
import org.nuxeo.ecm.core.persistence.PersistenceProviderFactory;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.impl.ExtendedInfoImpl;
import org.nuxeo.ecm.platform.audit.service.AbstractAuditBackend;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.LogEntryProvider;
import org.nuxeo.runtime.api.Framework;

public class DefaultAuditBackend
extends AbstractAuditBackend
implements AuditBackend {
    protected PersistenceProvider persistenceProvider;

    public PersistenceProvider getOrCreatePersistenceProvider() {
        if (this.persistenceProvider == null) {
            this.activatePersistenceProvider();
        }
        return this.persistenceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activatePersistenceProvider() {
        Thread thread = Thread.currentThread();
        ClassLoader last = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(PersistenceProvider.class.getClassLoader());
            PersistenceProviderFactory persistenceProviderFactory = (PersistenceProviderFactory)Framework.getLocalService(PersistenceProviderFactory.class);
            this.persistenceProvider = persistenceProviderFactory.newProvider("nxaudit-logs");
            this.persistenceProvider.openPersistenceUnit();
        }
        finally {
            thread.setContextClassLoader(last);
        }
    }

    protected void deactivatePersistenceProvider() {
        if (this.persistenceProvider != null) {
            this.persistenceProvider.closePersistenceUnit();
            this.persistenceProvider = null;
        }
    }

    @Override
    public void deactivate() {
        this.deactivatePersistenceProvider();
    }

    public void addLogEntries(final List<LogEntry> entries) {
        this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

            public void runWith(EntityManager em) {
                DefaultAuditBackend.this.addLogEntries(em, entries);
            }
        });
    }

    protected void addLogEntries(EntityManager em, List<LogEntry> entries) {
        LogEntryProvider.createProvider(em).addLogEntries(entries);
    }

    @Override
    public List<LogEntry> getLogEntriesFor(final String uuid) {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<LogEntry>>(){

            public List<LogEntry> runWith(EntityManager em) {
                return DefaultAuditBackend.this.getLogEntriesFor(em, uuid);
            }
        });
    }

    protected List<LogEntry> getLogEntriesFor(EntityManager em, String uuid) {
        return LogEntryProvider.createProvider(em).getLogEntriesFor(uuid);
    }

    public List<LogEntry> getLogEntriesFor(final String uuid, final Map<String, FilterMapEntry> filterMap, final boolean doDefaultSort) {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<LogEntry>>(){

            public List<LogEntry> runWith(EntityManager em) {
                return DefaultAuditBackend.this.getLogEntriesFor(em, uuid, filterMap, doDefaultSort);
            }
        });
    }

    protected List<LogEntry> getLogEntriesFor(EntityManager em, String uuid, Map<String, FilterMapEntry> filterMap, boolean doDefaultSort) {
        return LogEntryProvider.createProvider(em).getLogEntriesFor(uuid, filterMap, doDefaultSort);
    }

    public LogEntry getLogEntryByID(final long id) {
        return (LogEntry)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<LogEntry>(){

            public LogEntry runWith(EntityManager em) {
                return DefaultAuditBackend.this.getLogEntryByID(em, id);
            }
        });
    }

    protected LogEntry getLogEntryByID(EntityManager em, long id) {
        return LogEntryProvider.createProvider(em).getLogEntryByID(id);
    }

    @Override
    public List<LogEntry> nativeQueryLogs(final String whereClause, final int pageNb, final int pageSize) {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<LogEntry>>(){

            public List<LogEntry> runWith(EntityManager em) {
                return DefaultAuditBackend.this.nativeQueryLogs(em, whereClause, pageNb, pageSize);
            }
        });
    }

    protected List<LogEntry> nativeQueryLogs(EntityManager em, String whereClause, int pageNb, int pageSize) {
        return LogEntryProvider.createProvider(em).nativeQueryLogs(whereClause, pageNb, pageSize);
    }

    @Override
    public List<?> nativeQuery(final String query, final int pageNb, final int pageSize) {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), new PersistenceProvider.RunCallback<List<?>>(){

            public List<?> runWith(EntityManager em) {
                return DefaultAuditBackend.this.nativeQuery(em, query, pageNb, pageSize);
            }
        });
    }

    protected List<?> nativeQuery(EntityManager em, String query, int pageNb, int pageSize) {
        return LogEntryProvider.createProvider(em).nativeQuery(query, pageNb, pageSize);
    }

    public List<?> nativeQuery(final String query, final Map<String, Object> params, final int pageNb, final int pageSize) {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), new PersistenceProvider.RunCallback<List<?>>(){

            public List<?> runWith(EntityManager em) {
                return DefaultAuditBackend.this.nativeQuery(em, query, params, pageNb, pageSize);
            }
        });
    }

    protected List<?> nativeQuery(EntityManager em, String query, Map<String, Object> params, int pageNb, int pageSize) {
        return LogEntryProvider.createProvider(em).nativeQuery(query, params, pageNb, pageSize);
    }

    @Override
    public List<LogEntry> queryLogs(final String[] eventIds, final String dateRange) {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<LogEntry>>(){

            public List<LogEntry> runWith(EntityManager em) {
                return DefaultAuditBackend.this.queryLogs(em, eventIds, dateRange);
            }
        });
    }

    protected List<LogEntry> queryLogs(EntityManager em, String[] eventIds, String dateRange) {
        return LogEntryProvider.createProvider(em).queryLogs(eventIds, dateRange);
    }

    public List<LogEntry> queryLogsByPage(final String[] eventIds, final String dateRange, final String[] category, final String path, final int pageNb, final int pageSize) {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<LogEntry>>(){

            public List<LogEntry> runWith(EntityManager em) {
                return DefaultAuditBackend.this.queryLogsByPage(em, eventIds, dateRange, category, path, pageNb, pageSize);
            }
        });
    }

    protected List<LogEntry> queryLogsByPage(EntityManager em, String[] eventIds, String dateRange, String[] category, String path, int pageNb, int pageSize) {
        return LogEntryProvider.createProvider(em).queryLogsByPage(eventIds, dateRange, category, path, pageNb, pageSize);
    }

    public List<LogEntry> queryLogsByPage(final String[] eventIds, final Date limit, final String[] category, final String path, final int pageNb, final int pageSize) {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<LogEntry>>(){

            public List<LogEntry> runWith(EntityManager em) {
                return DefaultAuditBackend.this.queryLogsByPage(em, eventIds, limit, category, path, pageNb, pageSize);
            }
        });
    }

    protected List<LogEntry> queryLogsByPage(EntityManager em, String[] eventIds, Date limit, String[] category, String path, int pageNb, int pageSize) {
        return LogEntryProvider.createProvider(em).queryLogsByPage(eventIds, limit, category, path, pageNb, pageSize);
    }

    public long syncLogCreationEntries(final String repoId, final String path, final Boolean recurs) {
        return (Long)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<Long>(){

            public Long runWith(EntityManager em) {
                return DefaultAuditBackend.this.syncLogCreationEntries(em, repoId, path, recurs);
            }
        });
    }

    protected long syncLogCreationEntries(EntityManager em, String repoId, String path, Boolean recurs) {
        LogEntryProvider provider = LogEntryProvider.createProvider(em);
        return this.syncLogCreationEntries(provider, repoId, path, recurs);
    }

    public void addLogEntry(final LogEntry entry) {
        this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<Integer>(){

            public Integer runWith(EntityManager em) {
                DefaultAuditBackend.this.addLogEntry(em, entry);
                return 0;
            }
        });
    }

    public void addLogEntry(EntityManager em, LogEntry entry) {
        LogEntryProvider.createProvider(em).addLogEntry(entry);
    }

    public Long getEventsCount(final String eventId) {
        return (Long)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<Long>(){

            public Long runWith(EntityManager em) {
                return DefaultAuditBackend.this.getEventsCount(em, eventId);
            }
        });
    }

    public Long getEventsCount(EntityManager em, String eventId) {
        return LogEntryProvider.createProvider(em).countEventsById(eventId);
    }

    public List<String> getLoggedEventIds() {
        return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<String>>(){

            public List<String> runWith(EntityManager em) {
                return DefaultAuditBackend.this.getLoggedEventIds(em);
            }
        });
    }

    protected List<String> getLoggedEventIds(EntityManager em) {
        return LogEntryProvider.createProvider(em).findEventIds();
    }

    @Override
    public void logEvent(final Event event) {
        this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

            public void runWith(EntityManager em) {
                DefaultAuditBackend.this.logEvent(em, event);
            }
        });
    }

    @Override
    public void logEvents(final EventBundle eventBundle) {
        this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

            public void runWith(EntityManager em) {
                DefaultAuditBackend.this.logEvents(em, eventBundle);
            }
        });
    }

    protected void logEvents(EntityManager em, EventBundle eventBundle) {
        boolean processEvents = false;
        for (String name : this.getAuditableEventNames()) {
            if (!eventBundle.containsEventName(name)) continue;
            processEvents = true;
            break;
        }
        if (!processEvents) {
            return;
        }
        for (Event event : eventBundle) {
            this.logEvent(em, event);
        }
    }

    protected void logEvent(EntityManager em, Event event) {
        LogEntry entry = this.buildEntryFromEvent(event);
        if (entry != null) {
            this.addLogEntry(em, entry);
        }
    }

    protected List<LogEntry> queryLogsByPage(EntityManager em, String[] eventIds, String dateRange, String category, String path, int pageNb, int pageSize) {
        String[] categories = new String[]{category};
        return this.queryLogsByPage(em, eventIds, dateRange, categories, path, pageNb, pageSize);
    }

    protected List<LogEntry> queryLogsByPage(EntityManager em, String[] eventIds, Date limit, String category, String path, int pageNb, int pageSize) {
        String[] categories = new String[]{category};
        return this.queryLogsByPage(em, eventIds, limit, categories, path, pageNb, pageSize);
    }

    @Override
    public void onApplicationStarted() {
    }

    @Override
    public ExtendedInfo newExtendedInfo(Serializable value) {
        return ExtendedInfoImpl.createExtendedInfo(value);
    }
}

