/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.url.io;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentUrlJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "documentURL";
    @Inject
    private DocumentViewCodecManager viewCodecManager;

    public DocumentUrlJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        DocumentLocationImpl docLoc = new DocumentLocationImpl(document);
        String pCodecName = (String)this.ctx.getParameter("URLCodecName");
        String codecName = StringUtils.isBlank((String)pCodecName) ? this.viewCodecManager.getDefaultCodecName() : pCodecName;
        TypeInfo adapter = (TypeInfo)document.getAdapter(TypeInfo.class);
        if (adapter == null) {
            jg.writeNullField(NAME);
            return;
        }
        DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc, adapter.getDefaultView());
        String url = this.ctx.getBaseUrl() + this.viewCodecManager.getUrlFromDocumentView(codecName, (DocumentView)docView, false, null);
        jg.writeStringField(NAME, url);
    }
}

