/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.core.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.web.resources.api.Processor;
import org.nuxeo.ecm.web.resources.core.ProcessorDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ProcessorRegistry
extends ContributionFragmentRegistry<ProcessorDescriptor> {
    private static final Log log = LogFactory.getLog(ProcessorRegistry.class);
    protected final Map<String, ProcessorDescriptor> processors = new HashMap<String, ProcessorDescriptor>();

    public String getContributionId(ProcessorDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, ProcessorDescriptor contrib, ProcessorDescriptor newOrigContrib) {
        if (this.processors.containsKey(id)) {
            this.processors.remove(id);
        }
        if (contrib.isEnabled()) {
            this.processors.put(id, contrib);
            log.info((Object)("Registering processor with name " + id));
        }
    }

    public void contributionRemoved(String id, ProcessorDescriptor origContrib) {
        this.processors.remove(id);
        log.info((Object)("Unregistering processor with name " + id));
    }

    public ProcessorDescriptor clone(ProcessorDescriptor orig) {
        return orig.clone();
    }

    public void merge(ProcessorDescriptor src, ProcessorDescriptor dst) {
        dst.merge(src);
    }

    public Processor getProcessor(String id) {
        return this.processors.get(id);
    }

    public List<Processor> getProcessors() {
        return this.getProcessors(null);
    }

    public List<Processor> getProcessors(String type) {
        ArrayList<Processor> res = new ArrayList<Processor>();
        Collection<ProcessorDescriptor> all = this.processors.values();
        for (Processor processor : all) {
            if (type != null && !processor.getTypes().contains(type)) continue;
            res.add(processor);
        }
        Collections.sort(res);
        return res;
    }
}

