/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.EntityJsonReader;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentPropertiesJsonReader;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.core.io.WorkflowRequest;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class WorkflowRequestJsonReader
extends EntityJsonReader<WorkflowRequest> {
    protected static final Log log = LogFactory.getLog(WorkflowRequestJsonReader.class);
    public static final String ENTITY_TYPE = "workflow";
    private static final String USE_LEGACY_CONF_KEY = "nuxeo.document.routing.json.format.legacy";
    private Boolean useLegacy = null;
    @Inject
    SchemaManager schemaManager;
    @Inject
    DocumentRoutingService documentRoutingService;

    public WorkflowRequestJsonReader() {
        super(ENTITY_TYPE);
        String prop = Framework.getProperty((String)USE_LEGACY_CONF_KEY);
        this.useLegacy = prop != null && Boolean.parseBoolean(prop) ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
        return this.useLegacy == false && !this.ctx.getBooleanParameter(USE_LEGACY_CONF_KEY) && super.accept(clazz, genericType, mediatype);
    }

    protected WorkflowRequest readEntity(JsonNode jn) throws IOException {
        String workflowModelName = this.getStringField(jn, "workflowModelName");
        ArrayList<String> attachedDocumentIds = new ArrayList<String>();
        JsonNode attachedDocumentIdsNode = jn.get("attachedDocumentIds");
        if (attachedDocumentIdsNode != null) {
            Iterator it = attachedDocumentIdsNode.getElements();
            while (it.hasNext()) {
                attachedDocumentIds.add(((JsonNode)it.next()).getTextValue());
            }
        }
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        JsonNode variablesNode = jn.get("variables");
        if (variablesNode != null) {
            try (RenderingContext.SessionWrapper closeable = this.ctx.getSession(null);){
                CoreSession session = closeable.getSession();
                String workflowModelId = this.documentRoutingService.getRouteModelDocIdWithId(session, workflowModelName);
                DocumentModel model = session.getDocument((DocumentRef)new IdRef(workflowModelId));
                String workflowSchemaFacet = (String)((Object)model.getPropertyValue("docri:variablesFacet"));
                CompositeType type = this.schemaManager.getFacet(workflowSchemaFacet);
                String workflowSchema = type.getSchemaNames()[0];
                variables.putAll(this.getVariables(variablesNode, workflowSchema));
            }
        }
        return new WorkflowRequest(workflowModelName, attachedDocumentIds, variables);
    }

    private Map<String, Serializable> getVariables(JsonNode variables, String schemaName) throws IOException {
        HashMap<String, Serializable> variable = new HashMap<String, Serializable>();
        ParameterizedType genericType = TypeUtils.parameterize(List.class, (Type[])new Type[]{Property.class});
        try (Closeable resource = this.ctx.wrap().with(DocumentPropertiesJsonReader.DEFAULT_SCHEMA_NAME, (Object)schemaName).open();){
            List properties = (List)this.readEntity(List.class, genericType, variables);
            for (Property property : properties) {
                variable.put(property.getName().substring(schemaName.length() + 1), property.getValue());
            }
        }
        return variable;
    }
}

