/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import yarfraw.core.datamodel.YarfrawException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtils {
    private XMLUtils() {
    }

    public static Document parseXml(String xml, boolean validating, boolean ignoringComments) throws SAXException, IOException, ParserConfigurationException {
        return XMLUtils.parseXml(new InputSource(new StringReader(xml)), validating, ignoringComments);
    }

    public static Document parseXml(InputStream stream, boolean validating, boolean ignoringComments) throws SAXException, IOException, ParserConfigurationException {
        return XMLUtils.parseXml(new InputSource(stream), validating, ignoringComments);
    }

    public static Document parseXml(InputSource source, boolean validating, boolean ignoringComments) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validating);
        factory.setIgnoringComments(ignoringComments);
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder().parse(source);
    }

    public static Element getElementByNS(List<Element> elements, String namespaceURI, String localName) {
        if (CollectionUtils.isEmpty(elements)) {
            return null;
        }
        for (Element e : elements) {
            if (!ObjectUtils.equals((Object)localName, (Object)e.getLocalName()) || !ObjectUtils.equals((Object)namespaceURI, (Object)XMLUtils.emptyIfNull(e.getNamespaceURI()))) continue;
            return e;
        }
        return null;
    }

    public static Element getElementByLocalName(List<Element> elements, String localName) {
        if (CollectionUtils.isEmpty(elements)) {
            return null;
        }
        for (Element e : elements) {
            if (!ObjectUtils.equals((Object)localName, (Object)e.getLocalName())) continue;
            return e;
        }
        return null;
    }

    public static boolean same(QName qn1, QName qn2) {
        return ObjectUtils.equals((Object)qn1, (Object)qn2);
    }

    public static String emptyIfNull(String str) {
        return str == null ? "" : str;
    }

    public static String getAttributeValue(Node element, QName name) {
        return XMLUtils.getAttributeValue(element, name.getLocalPart(), name.getNamespaceURI());
    }

    public static String getAttributeValue(Node element, String attributeLocalName) {
        return XMLUtils.getAttributeValue(element, attributeLocalName, null);
    }

    public static String getAttributeValue(Node element, String attributeLocalName, String namespaceUri) {
        NamedNodeMap attr = element.getAttributes();
        if (attr == null) {
            return null;
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            boolean sameUri;
            Node a = attr.item(i);
            boolean bl = sameUri = namespaceUri == null ? true : namespaceUri.equals(a.getNamespaceURI());
            if (!sameUri || !attributeLocalName.equals(a.getLocalName())) continue;
            return a.getNodeValue();
        }
        return null;
    }

    public static QName getQName(Node n) {
        return new QName(XMLUtils.emptyIfNull(n.getNamespaceURI()), n.getLocalName());
    }

    public static List<Node> getChildrenNodesByName(Node parent, String localName) {
        return XMLUtils.getChildrenByName(parent, localName, false);
    }

    public static Node getChildrenNodeByName(Node parent, String localName) {
        List<Node> result = XMLUtils.getChildrenByName(parent, localName, true);
        return result.size() > 0 ? result.get(0) : null;
    }

    public static String transformWithXsl(String xslt, String xml) throws YarfrawException {
        StreamSource source = new StreamSource(xml);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult res = new StreamResult(out);
        TransformerFactory transFact = TransformerFactory.newInstance();
        try {
            Transformer trans = transFact.newTransformer(new StreamSource(xslt));
            trans.transform(source, res);
        }
        catch (TransformerConfigurationException e) {
            throw new YarfrawException("Transformer config exception", e);
        }
        catch (TransformerException e) {
            throw new YarfrawException("Transform exception", e);
        }
        return out.toString();
    }

    private static List<Node> getChildrenByName(Node parent, String localName, boolean single) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!localName.equals(list.item(i).getLocalName())) continue;
            nodes.add(list.item(i));
            if (!single) continue;
            return nodes;
        }
        return nodes;
    }
}

