/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.core.datamodel;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import yarfraw.core.datamodel.AbstractBaseObject;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.ValidationException;
import yarfraw.utils.ValidationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Image
extends AbstractBaseObject {
    private static final long serialVersionUID = 20070927L;
    private String _url;
    private String _title;
    private String _link;
    private Integer _width = 88;
    private Integer _height = 31;
    private String _description;

    public Image() {
    }

    public Image(String url, String title, String link, Integer width, Integer height, String description) {
        this.setUrl(url);
        this._title = title;
        this.setLink(link);
        this.setHeight(height);
        this.setWidth(width);
        this._description = description;
    }

    public Image setUrl(String url) {
        this._url = url;
        return this;
    }

    public String getTitle() {
        return this._title;
    }

    public Image setTitle(String title) {
        this._title = title;
        return this;
    }

    public Image setLink(String link) {
        this._link = link;
        return this;
    }

    public String getUrl() {
        return this._url;
    }

    public String getLink() {
        return this._link;
    }

    public Integer getWidth() {
        return this._width;
    }

    public Image setWidth(Integer width) {
        if (width == null) {
            this._width = 88;
            return this;
        }
        this._width = width;
        return this;
    }

    public Integer getHeight() {
        return this._height;
    }

    public Image setHeight(Integer height) {
        if (height == null) {
            this._width = 31;
            return this;
        }
        this._height = height;
        return this;
    }

    public String getDescription() {
        return this._description;
    }

    public Image setDescription(String description) {
        this._description = description;
        return this;
    }

    public Image setOtherAttributes(Map<QName, String> otherAttributes) {
        this._otherAttributes = otherAttributes;
        return this;
    }

    public Image addOtherAttributes(QName namespace, String attribute) {
        if (this._otherAttributes == null) {
            this._otherAttributes = new HashMap();
        }
        this._otherAttributes.put(namespace, attribute);
        return this;
    }

    public Image setBase(String base) {
        this._base = base;
        return this;
    }

    public Image setLang(String lang) {
        this._lang = lang;
        return this;
    }

    public Image setLang(Locale lang) {
        this._lang = lang.getLanguage();
        return this;
    }

    public Image setResource(String resource) {
        this._resource = resource;
        return this;
    }

    public Image setAbout(String about) {
        this._about = about;
        return this;
    }

    @Override
    public void validate(FeedFormat format) throws ValidationException {
        if (format == FeedFormat.RSS20) {
            ValidationUtils.validateNotNull("Image: All required fields in the Image object should be not null", this._url, this._title, this._link);
            ValidationUtils.validateUri("Url or link is not a valid URI", this._url, this._link);
            if (this._width > 144 || this._width < 0) {
                throw new ValidationException("[Image] Maximum value for width is 144, according to RSS20 specs");
            }
            if (this._height > 400 || this._height < 0) {
                throw new ValidationException("[Image] Maximum value for height is 400, according to RSS20 specs");
            }
        } else {
            ValidationUtils.validateNotNull("Image: url should not be null", this._url);
            ValidationUtils.validateUri("Url is not a valid URI", this._url);
        }
        if (format == FeedFormat.RSS10) {
            ValidationUtils.validateNotNull("attribute 'about' is required", this.getAbout());
        }
    }
}

