/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UsernameTokenInterceptor
extends AbstractSoapInterceptor {
    protected static final String WSSE_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    protected static final QName WSSE_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    protected static final String WSSE_USERNAME_TOKEN = "UsernameToken";
    protected static final String WSSE_USERNAME = "Username";
    protected static final String WSSE_PASSWORD = "Password";
    protected static final String WSSE_PASSWORD_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";

    public UsernameTokenInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(SoapMessage message) {
        Header securityHeader = message.getHeader(WSSE_SECURITY);
        if (securityHeader != null) {
            if (!(securityHeader.getObject() instanceof Node)) {
                throw new CmisRuntimeException("Cannot read Security header.");
            }
            Node usernameTokenNode = this.getUsernameTokenNode((Node)securityHeader.getObject());
            if (usernameTokenNode == null) {
                return;
            }
            String username = this.getUsername(usernameTokenNode);
            if (username == null) {
                return;
            }
            String password = this.getPasswordText(usernameTokenNode);
            HashMap<String, String> callContextMap = new HashMap<String, String>();
            callContextMap.put("username", username);
            callContextMap.put("password", password);
            message.getExchange().getInMessage().put((Object)"org.apache.chemistry.opencmis.callcontext", callContextMap);
        }
    }

    protected Node getUsernameTokenNode(Node securityNode) {
        return this.findElement(securityNode, WSSE_NS, WSSE_USERNAME_TOKEN);
    }

    protected String getUsername(Node usernameTokenNode) {
        Node node = this.findElement(usernameTokenNode, WSSE_NS, WSSE_USERNAME);
        if (node != null) {
            return node.getTextContent();
        }
        return null;
    }

    protected String getPasswordText(Node usernameTokenNode) {
        Node type;
        Node node = this.findElement(usernameTokenNode, WSSE_NS, WSSE_PASSWORD);
        if (node != null && ((type = node.getAttributes().getNamedItem("Type")) == null || WSSE_PASSWORD_TYPE.equals(type.getTextContent()))) {
            return node.getTextContent();
        }
        return null;
    }

    protected Node findElement(Node parent, String namespace, String localname) {
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!namespace.equals(node.getNamespaceURI()) || !localname.equals(node.getLocalName()) || node.getNodeType() != 1) continue;
            return node;
        }
        return null;
    }
}

