/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.PermissionDescriptor;

@XObject(value="directory")
public class BaseDirectoryDescriptor
implements Cloneable {
    private static final Log log = LogFactory.getLog(BaseDirectoryDescriptor.class);
    public static final int CACHE_TIMEOUT_DEFAULT = 0;
    public static final int CACHE_MAX_SIZE_DEFAULT = 0;
    public static final boolean READ_ONLY_DEFAULT = false;
    public static final SubstringMatchType SUBSTRING_MATCH_TYPE_DEFAULT = SubstringMatchType.subinitial;
    @XNode(value="@name")
    public String name;
    @XNode(value="@remove")
    public boolean remove;
    @XNode(value="@template")
    public boolean template;
    @XNode(value="@extends")
    public String extendz;
    @XNode(value="parentDirectory")
    public String parentDirectory;
    @XNode(value="schema")
    public String schemaName;
    @XNode(value="idField")
    public String idField;
    @XNode(value="table")
    public String tableName;
    @XNode(value="readOnly")
    public Boolean readOnly;
    @XNode(value="passwordField")
    public String passwordField;
    @XNode(value="passwordHashAlgorithm")
    public String passwordHashAlgorithm;
    @XNodeList(value="permissions/permission", type=PermissionDescriptor[].class, componentType=PermissionDescriptor.class)
    public PermissionDescriptor[] permissions;
    @XNode(value="cacheTimeout")
    public Integer cacheTimeout;
    @XNode(value="cacheMaxSize")
    public Integer cacheMaxSize;
    @XNode(value="cacheEntryName")
    public String cacheEntryName;
    @XNode(value="cacheEntryWithoutReferencesName")
    public String cacheEntryWithoutReferencesName;
    @XNode(value="negativeCaching")
    public Boolean negativeCaching;
    @XNode(value="substringMatchType")
    public String substringMatchType;

    public boolean isReadOnly() {
        return this.readOnly == null ? false : this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int getCacheTimeout() {
        return this.cacheTimeout == null ? 0 : this.cacheTimeout;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize == null ? 0 : this.cacheMaxSize;
    }

    public SubstringMatchType getSubstringMatchType() {
        if (StringUtils.isBlank((String)this.substringMatchType)) {
            return SUBSTRING_MATCH_TYPE_DEFAULT;
        }
        try {
            return SubstringMatchType.valueOf(this.substringMatchType);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("Unknown value for <substringMatchType>: " + this.substringMatchType));
            return SUBSTRING_MATCH_TYPE_DEFAULT;
        }
    }

    public BaseDirectoryDescriptor clone() {
        BaseDirectoryDescriptor clone;
        try {
            clone = (BaseDirectoryDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        if (this.permissions != null) {
            clone.permissions = new PermissionDescriptor[this.permissions.length];
            for (int i = 0; i < this.permissions.length; ++i) {
                clone.permissions[i] = this.permissions[i].clone();
            }
        }
        return clone;
    }

    public void merge(BaseDirectoryDescriptor other) {
        boolean bl = this.template = this.template || other.template;
        if (other.parentDirectory != null) {
            this.parentDirectory = other.parentDirectory;
        }
        if (other.schemaName != null) {
            this.schemaName = other.schemaName;
        }
        if (other.idField != null) {
            this.idField = other.idField;
        }
        if (other.tableName != null) {
            this.tableName = other.tableName;
        }
        if (other.readOnly != null) {
            this.readOnly = other.readOnly;
        }
        if (other.passwordField != null) {
            this.passwordField = other.passwordField;
        }
        if (other.passwordHashAlgorithm != null) {
            this.passwordHashAlgorithm = other.passwordHashAlgorithm;
        }
        if (other.permissions != null && other.permissions.length != 0) {
            this.permissions = other.permissions;
        }
        if (other.cacheTimeout != null) {
            this.cacheTimeout = other.cacheTimeout;
        }
        if (other.cacheMaxSize != null) {
            this.cacheMaxSize = other.cacheMaxSize;
        }
        if (other.cacheEntryName != null) {
            this.cacheEntryName = other.cacheEntryName;
        }
        if (other.cacheEntryWithoutReferencesName != null) {
            this.cacheEntryWithoutReferencesName = other.cacheEntryWithoutReferencesName;
        }
        if (other.negativeCaching != null) {
            this.negativeCaching = other.negativeCaching;
        }
        if (other.substringMatchType != null) {
            this.substringMatchType = other.substringMatchType;
        }
    }

    public Directory newDirectory() {
        throw new UnsupportedOperationException("Cannot be instantiated as Directory: " + this.getClass().getName());
    }

    public static enum SubstringMatchType {
        subinitial,
        subfinal,
        subany;

    }
}

