/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.io.plugins.helpers;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class TranslationHelper {
    public static final String DEFAULT_LOCALE = "en";

    protected static ResourceBundle getBundle(String lang) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return ResourceBundle.getBundle("messages", new Locale(lang), cl);
    }

    public static String getTranslation(String key, String lang) {
        ResourceBundle defaultBundle = null;
        ResourceBundle bundle = TranslationHelper.getBundle(lang);
        if (bundle == null) {
            bundle = defaultBundle = TranslationHelper.getBundle(DEFAULT_LOCALE);
        }
        String translation = null;
        if (bundle != null && bundle.containsKey(key)) {
            translation = bundle.getString(key);
        }
        if (translation == null && !lang.equals(DEFAULT_LOCALE)) {
            if (defaultBundle == null) {
                defaultBundle = TranslationHelper.getBundle(DEFAULT_LOCALE);
            }
            if (defaultBundle.containsKey(key)) {
                translation = defaultBundle.getString(key);
            }
        }
        if (translation == null) {
            translation = key;
        }
        return translation;
    }

    public static Map<String, String> getTranslatedLabels(Map<String, String> labels, String lang) {
        if (labels != null) {
            HashMap<String, String> res = new HashMap<String, String>();
            for (Map.Entry<String, String> label : labels.entrySet()) {
                res.put(label.getKey(), TranslationHelper.getTranslation(label.getValue(), lang));
            }
            return res;
        }
        return null;
    }
}

