/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag.automation;

import java.util.Collections;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.Component;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Operation(id="Tag.Suggestion", category="Services", label="Get tag suggestion", description="Get tag suggestion")
public class SuggestTagEntry {
    public static final String ID = "Tag.Suggestion";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession documentManager;
    @Context
    protected TagService tagService;
    @Param(name="searchTerm", required=false)
    protected String searchTerm;
    @Param(name="value", required=false)
    protected String value;
    @Param(name="xpath", required=false)
    protected String xpath;

    @OperationMethod
    public Blob run() {
        JSONArray result;
        block3: {
            block4: {
                result = new JSONArray();
                if (this.tagService == null || !this.tagService.isEnabled()) break block3;
                if (StringUtils.isEmpty((String)this.value)) break block4;
                NavigationContext navigationContext = (NavigationContext)Component.getInstance((String)"navigationContext");
                DocumentModel currentDocument = navigationContext.getCurrentDocument();
                if (currentDocument == null) {
                    return null;
                }
                String docId = currentDocument.getId();
                List tags = this.tagService.getDocumentTags(this.documentManager, docId, null);
                Collections.sort(tags, Tag.LABEL_COMPARATOR);
                for (Tag tag : tags) {
                    JSONObject obj = new JSONObject();
                    obj.element("id", (Object)tag.getLabel());
                    obj.element("displayLabel", (Object)tag.getLabel());
                    result.add((Object)obj);
                }
                break block3;
            }
            if (StringUtils.isBlank((String)this.searchTerm)) break block3;
            List tags = this.tagService.getSuggestions(this.documentManager, this.searchTerm, null);
            Collections.sort(tags, Tag.LABEL_COMPARATOR);
            for (int i = 0; i < 10 && i < tags.size(); ++i) {
                JSONObject obj = new JSONObject();
                Tag tag = (Tag)tags.get(i);
                obj.element("id", (Object)tag.getLabel());
                obj.element("displayLabel", (Object)tag.getLabel());
                result.add((Object)obj);
            }
        }
        return Blobs.createBlob((String)result.toString(), (String)"application/json");
    }
}

