/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.wiki;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.rendering.wiki.WikiSerializerHandler;
import org.nuxeo.ecm.platform.rendering.wiki.WikiText;
import org.wikimodel.wem.IWikiPrinter;

public class WikiWriter
implements IWikiPrinter,
WikiText {
    protected static final Log log = LogFactory.getLog(WikiWriter.class);
    protected static final String LINE_SEP = System.getProperty("line.separator");
    protected WikiWriter parent;
    protected final List<String> segments = new ArrayList<String>();
    protected final List<WikiText> dynamicSegments = new ArrayList<WikiText>();
    protected final StringBuilder buf = new StringBuilder();

    public WikiWriter() {
    }

    public WikiWriter(WikiWriter parent) {
        this.parent = parent;
    }

    public void print(String str) {
        this.buf.append(str);
    }

    public void println() {
        this.buf.append(LINE_SEP);
    }

    public void println(String str) {
        this.buf.append(str);
        this.buf.append(LINE_SEP);
    }

    public void writeText(WikiText text) {
        this.segments.add(this.buf.toString());
        this.buf.setLength(0);
        this.dynamicSegments.add(text);
    }

    public WikiWriter getParent() {
        return this.parent;
    }

    public StringBuilder getBuffer() {
        return this.buf;
    }

    @Override
    public void writeTo(WikiSerializerHandler handler, Writer writer) throws IOException {
        int len = this.segments.size();
        for (int i = 0; i < len; ++i) {
            writer.write(this.segments.get(i));
            this.dynamicSegments.get(i).writeTo(handler, writer);
        }
        writer.write(this.buf.toString());
    }
}

