/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.tools.SimpleResultSet;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;

public class H2Fulltext {
    private static final Version LUCENE_VERSION = Version.LUCENE_4_10_4;
    private static final Map<String, Analyzer> analyzers = new ConcurrentHashMap<String, Analyzer>();
    private static final Map<String, IndexWriter> indexWriters = new ConcurrentHashMap<String, IndexWriter>();
    private static final String FT_SCHEMA = "NXFT";
    private static final String FT_TABLE = "NXFT.INDEXES";
    private static final String PREFIX = "NXFT_";
    private static final String FIELD_KEY = "KEY";
    private static final String FIELD_TEXT = "TEXT";
    private static final String DEFAULT_INDEX_NAME = "PUBLIC_FULLTEXT_default";
    private static final String COL_KEY = "KEY";

    private H2Fulltext() {
    }

    public static void init(Connection conn) throws SQLException {
        try (Statement st = conn.createStatement();){
            st.execute("CREATE SCHEMA IF NOT EXISTS NXFT");
            st.execute("CREATE TABLE IF NOT EXISTS NXFT.INDEXES(NAME VARCHAR, SCHEMA VARCHAR, TABLE VARCHAR, COLUMNS VARCHAR, ANALYZER VARCHAR, PRIMARY KEY(NAME))");
            try (ResultSet rs = st.executeQuery("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'NXFT' AND TABLE_NAME = 'INDEXES' AND COLUMN_NAME = 'NAME'");){
                if (!rs.next()) {
                    st.execute("ALTER TABLE NXFT.INDEXES ADD COLUMN NAME VARCHAR");
                    st.execute("UPDATE NXFT.INDEXES SET NAME = 'PUBLIC_FULLTEXT_default'");
                }
            }
            String className = H2Fulltext.class.getName();
            st.execute("CREATE ALIAS IF NOT EXISTS NXFT_CREATE_INDEX FOR \"" + className + ".createIndex\"");
            st.execute("CREATE ALIAS IF NOT EXISTS NXFT_REINDEX FOR \"" + className + ".reindex\"");
            st.execute("CREATE ALIAS IF NOT EXISTS NXFT_DROP_ALL FOR \"" + className + ".dropAll\"");
            st.execute("CREATE ALIAS IF NOT EXISTS NXFT_SEARCH FOR \"" + className + ".search\"");
        }
    }

    public static void createIndex(Connection conn, String indexName, String schema, String table, String columns, String analyzer) throws SQLException {
        if (indexName == null) {
            indexName = DEFAULT_INDEX_NAME;
        }
        columns = columns.replace("(", "").replace(")", "").replace(" ", "");
        try (PreparedStatement ps = conn.prepareStatement("DELETE FROM NXFT.INDEXES WHERE NAME = ?");){
            ps.setString(1, indexName);
            ps.execute();
        }
        ps = conn.prepareStatement("INSERT INTO NXFT.INDEXES(NAME, SCHEMA, TABLE, COLUMNS, ANALYZER) VALUES(?, ?, ?, ?, ?)");
        var7_7 = null;
        try {
            ps.setString(1, indexName);
            ps.setString(2, schema);
            ps.setString(3, table);
            ps.setString(4, columns);
            ps.setString(5, analyzer);
            ps.execute();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (ps != null) {
                if (var7_7 != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    ps.close();
                }
            }
        }
        H2Fulltext.createTrigger(conn, schema, table);
    }

    public static void reindex(Connection conn) throws SQLException {
        H2Fulltext.removeAllTriggers(conn);
        H2Fulltext.removeIndexFiles(conn);
        try (Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery("SELECT * FROM NXFT.INDEXES");){
            HashSet<String> done = new HashSet<String>();
            while (rs.next()) {
                String schema = rs.getString("SCHEMA");
                String table = rs.getString("TABLE");
                String key = schema + '.' + table;
                if (!done.add(key)) continue;
                H2Fulltext.createTrigger(conn, schema, table);
                H2Fulltext.indexExistingRows(conn, schema, table);
            }
        }
    }

    private static void indexExistingRows(Connection conn, String schema, String table) throws SQLException {
        Trigger trigger = new Trigger();
        trigger.init(conn, schema, null, table, false, 1);
        try (Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery("SELECT * FROM " + StringUtils.quoteIdentifier((String)schema) + '.' + StringUtils.quoteIdentifier((String)table));){
            int n = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                Object[] row = new Object[n];
                for (int i = 0; i < n; ++i) {
                    row[i] = rs.getObject(i + 1);
                }
                trigger.fire(conn, null, row);
            }
        }
    }

    private static void createTrigger(Connection conn, String schema, String table) throws SQLException {
        try (Statement st = conn.createStatement();){
            schema = StringUtils.quoteIdentifier((String)schema);
            String trigger = schema + '.' + StringUtils.quoteIdentifier((String)(PREFIX + table));
            st.execute("DROP TRIGGER IF EXISTS " + trigger);
            st.execute(String.format("CREATE TRIGGER %s AFTER INSERT, UPDATE, DELETE ON %s.%s FOR EACH ROW CALL \"%s\"", trigger, schema, StringUtils.quoteIdentifier((String)table), Trigger.class.getName()));
        }
    }

    private static void removeAllTriggers(Connection conn) throws SQLException {
        try (Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery("SELECT * FROM INFORMATION_SCHEMA.TRIGGERS");
             Statement st2 = conn.createStatement();){
            while (rs.next()) {
                String trigger = rs.getString("TRIGGER_NAME");
                if (!trigger.startsWith(PREFIX)) continue;
                st2.execute("DROP TRIGGER " + StringUtils.quoteIdentifier((String)rs.getString("TRIGGER_SCHEMA")) + "." + trigger);
            }
        }
    }

    public static void dropAll(Connection conn) throws SQLException {
        try (Statement st = conn.createStatement();){
            st.execute("DROP SCHEMA IF EXISTS NXFT");
        }
        H2Fulltext.removeAllTriggers(conn);
        H2Fulltext.removeIndexFiles(conn);
    }

    private static String fieldForIndex(String indexName) {
        if (DEFAULT_INDEX_NAME.equals(indexName)) {
            return FIELD_TEXT;
        }
        return "TEXT_" + indexName;
    }

    public static ResultSet search(Connection conn, String indexName, String text) throws SQLException {
        String analyzerName;
        String table;
        String schema;
        DatabaseMetaData meta = conn.getMetaData();
        if (indexName == null) {
            indexName = DEFAULT_INDEX_NAME;
        }
        try (PreparedStatement ps = conn.prepareStatement("SELECT SCHEMA, TABLE, ANALYZER FROM NXFT.INDEXES WHERE NAME = ?");){
            ps.setString(1, indexName);
            try (ResultSet res = ps.executeQuery();){
                if (!res.next()) {
                    throw new SQLException("No such index: " + indexName);
                }
                schema = res.getString(1);
                table = res.getString(2);
                analyzerName = res.getString(3);
            }
        }
        int type = H2Fulltext.getPrimaryKeyType(meta, schema, table);
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn("KEY", type, 0, 0);
        if (meta.getURL().startsWith("jdbc:columnlist:")) {
            return rs;
        }
        IndexWriter writer = H2Fulltext.getIndexWriter(H2Fulltext.getIndexName(conn), H2Fulltext.getIndexPath(conn), analyzerName);
        if (writer.hasUncommittedChanges()) {
            try {
                writer.commit();
            }
            catch (IOException cause) {
                throw H2Fulltext.convertException(cause);
            }
        }
        try {
            BooleanQuery query = new BooleanQuery();
            String defaultField = H2Fulltext.fieldForIndex(indexName);
            Analyzer analyzer = H2Fulltext.getAnalyzer(analyzerName);
            QueryParser parser = new QueryParser(LUCENE_VERSION, defaultField, analyzer);
            query.add(parser.parse(text), BooleanClause.Occur.MUST);
            try (DirectoryReader reader = DirectoryReader.open((Directory)writer.getDirectory());){
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                ResultSetCollector collector = new ResultSetCollector(rs, (IndexReader)reader, type);
                searcher.search((Query)query, (Collector)collector);
            }
        }
        catch (IOException | SQLException | ParseException e) {
            throw H2Fulltext.convertException((Exception)e);
        }
        return rs;
    }

    private static int getPrimaryKeyType(DatabaseMetaData meta, String schema, String table) throws SQLException {
        String primaryKeyName = null;
        try (ResultSet rs = meta.getPrimaryKeys(null, schema, table);){
            while (rs.next()) {
                if (primaryKeyName != null) {
                    throw new SQLException("Can only index primary keys on one column for " + schema + '.' + table);
                }
                primaryKeyName = rs.getString("COLUMN_NAME");
            }
            if (primaryKeyName == null) {
                throw new SQLException("No primary key for " + schema + '.' + table);
            }
        }
        rs = meta.getColumns(null, schema, table, primaryKeyName);
        var5_5 = null;
        try {
            if (!rs.next()) {
                throw new SQLException("Could not find primary key");
            }
            int n = rs.getInt("DATA_TYPE");
            return n;
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (var5_5 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
    }

    private static Analyzer getAnalyzer(String analyzerName) throws SQLException {
        Analyzer analyzer = analyzers.get(analyzerName);
        if (analyzer == null) {
            try {
                Class<?> klass = Class.forName(analyzerName);
                Constructor<?> constructor = klass.getConstructor(Version.class);
                analyzer = (Analyzer)constructor.newInstance(LUCENE_VERSION);
            }
            catch (ReflectiveOperationException e) {
                throw new SQLException(e.toString());
            }
            analyzers.put(analyzerName, analyzer);
        }
        return analyzer;
    }

    protected static String getIndexName(Connection conn) throws SQLException {
        String catalog = conn.getCatalog();
        if (catalog == null) {
            catalog = "default";
        }
        return catalog;
    }

    /*
     * Exception decompiling
     */
    protected static String getIndexPath(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexWriter getIndexWriter(String name, String path, String analyzer) throws SQLException {
        IndexWriter indexWriter = indexWriters.get(name);
        if (indexWriter != null) {
            return indexWriter;
        }
        Map<String, IndexWriter> map = indexWriters;
        synchronized (map) {
            indexWriter = indexWriters.get(name);
            if (indexWriter != null) {
                return indexWriter;
            }
            try {
                RAMDirectory dir = path == null ? new RAMDirectory() : FSDirectory.open((File)new File(path));
                Analyzer an = H2Fulltext.getAnalyzer(analyzer);
                IndexWriterConfig iwc = new IndexWriterConfig(LUCENE_VERSION, an);
                iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                indexWriter = new IndexWriter((Directory)dir, iwc);
            }
            catch (LockObtainFailedException e) {
                throw H2Fulltext.convertException("Cannot open fulltext index " + path, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw H2Fulltext.convertException(e);
            }
            indexWriters.put(name, indexWriter);
            return indexWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeIndexFiles(Connection conn) throws SQLException {
        block5: {
            String path = H2Fulltext.getIndexPath(conn);
            try {
                IndexWriter index = indexWriters.remove(path);
                if (index == null) break block5;
                try {
                    index.close();
                }
                catch (IOException e) {
                    throw H2Fulltext.convertException(e);
                }
            }
            finally {
                FileUtils.deleteRecursive((String)path, (boolean)false);
            }
        }
    }

    private static SQLException convertException(Exception e) {
        return H2Fulltext.convertException("Error while indexing document", e);
    }

    private static SQLException convertException(String message, Exception e) {
        SQLException e2 = new SQLException(message);
        e2.initCause(e);
        return e2;
    }

    protected static String asString(Object data, int type) throws SQLException {
        if (data == null) {
            return "";
        }
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                return data.toString();
            }
            case 2005: {
                try {
                    if (data instanceof Clob) {
                        data = ((Clob)data).getCharacterStream();
                    }
                    return IOUtils.readStringAndClose((Reader)((Reader)data), (int)-1);
                }
                catch (IOException e) {
                    throw DbException.convert((Throwable)e);
                }
            }
            case -4: 
            case -3: 
            case -2: 
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2006: {
                throw new SQLException("Unsupported column data type: " + type);
            }
        }
        return "";
    }

    private static Object asObject(String string, int type) throws SQLException {
        switch (type) {
            case -5: {
                return Long.valueOf(string);
            }
            case -6: 
            case 4: 
            case 5: {
                return Integer.valueOf(string);
            }
            case -1: 
            case 1: 
            case 12: {
                return string;
            }
        }
        throw new SQLException("Unsupport data type for primary key: " + type);
    }

    public static class Trigger
    implements org.h2.api.Trigger {
        private static final Log log = LogFactory.getLog(Trigger.class);
        private String indexName;
        private String indexPath;
        private IndexWriter indexWriter;
        private Exception lastIndexWriterClose;
        private String lastIndexWriterCloseThread;
        private int primaryKeyIndex;
        private int primaryKeyType;
        private Map<String, int[]> columnTypes;
        private Map<String, int[]> columnIndices;

        public void init(Connection conn, String schema, String triggerName, String table, boolean before, int opType) throws SQLException {
            DatabaseMetaData meta = conn.getMetaData();
            String primaryKeyName = null;
            try (ResultSet rs = meta.getPrimaryKeys(null, schema, table);){
                while (rs.next()) {
                    if (primaryKeyName != null) {
                        throw new SQLException("Can only index primary keys on one column for: " + schema + '.' + table);
                    }
                    primaryKeyName = rs.getString("COLUMN_NAME");
                }
                if (primaryKeyName == null) {
                    throw new SQLException("No primary key for " + schema + '.' + table);
                }
            }
            rs = meta.getColumns(null, schema, table, primaryKeyName);
            var10_10 = null;
            try {
                if (!rs.next()) {
                    throw new SQLException("No primary key for: " + schema + '.' + table);
                }
                this.primaryKeyType = rs.getInt("DATA_TYPE");
                this.primaryKeyIndex = rs.getInt("ORDINAL_POSITION") - 1;
            }
            catch (Throwable throwable) {
                var10_10 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var10_10 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var10_10.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            HashMap<String, Integer> allColumnTypes = new HashMap<String, Integer>();
            HashMap<String, Integer> allColumnIndices = new HashMap<String, Integer>();
            try (ResultSet rs = meta.getColumns(null, schema, table, null);){
                while (rs.next()) {
                    String name = rs.getString("COLUMN_NAME");
                    int type = rs.getInt("DATA_TYPE");
                    int index = rs.getInt("ORDINAL_POSITION") - 1;
                    allColumnTypes.put(name, type);
                    allColumnIndices.put(name, index);
                }
            }
            var12_17 = null;
            try (PreparedStatement ps = conn.prepareStatement("SELECT NAME, COLUMNS, ANALYZER FROM NXFT.INDEXES WHERE SCHEMA = ? AND TABLE = ?");){
                ps.setString(1, schema);
                ps.setString(2, table);
                try (ResultSet rs = ps.executeQuery();){
                    this.columnTypes = new HashMap<String, int[]>();
                    this.columnIndices = new HashMap<String, int[]>();
                    while (rs.next()) {
                        String index = rs.getString(1);
                        String columns = rs.getString(2);
                        String analyzerName = rs.getString(3);
                        List<String> columnNames = Arrays.asList(columns.split(","));
                        int[] types = new int[columnNames.size()];
                        int[] indices = new int[columnNames.size()];
                        int i = 0;
                        for (String columnName : columnNames) {
                            types[i] = (Integer)allColumnTypes.get(columnName);
                            indices[i] = (Integer)allColumnIndices.get(columnName);
                            ++i;
                        }
                        this.columnTypes.put(index, types);
                        this.columnIndices.put(index, indices);
                        this.indexName = H2Fulltext.getIndexName(conn);
                        this.indexPath = H2Fulltext.getIndexPath(conn);
                        this.indexWriter = H2Fulltext.getIndexWriter(this.indexName, this.indexPath, analyzerName);
                    }
                }
            }
            catch (Throwable throwable) {
                var12_17 = throwable;
                throw throwable;
            }
        }

        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
            if (this.indexWriter == null) {
                throw new SQLException("Fulltext index was not initialized");
            }
            if (oldRow != null) {
                this.delete(oldRow);
            }
            if (newRow != null) {
                this.insert(newRow);
            }
        }

        private void insert(Object[] row) throws SQLException {
            Document doc = new Document();
            String key = H2Fulltext.asString(row[this.primaryKeyIndex], this.primaryKeyType);
            StringField keyField = new StringField("KEY", key, Field.Store.YES);
            doc.add((IndexableField)keyField);
            for (String indexName : this.columnTypes.keySet()) {
                int[] types = this.columnTypes.get(indexName);
                int[] indices = this.columnIndices.get(indexName);
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < types.length; ++i) {
                    String data = H2Fulltext.asString(row[indices[i]], types[i]);
                    if (i > 0) {
                        buf.append(' ');
                    }
                    buf.append(data);
                }
                TextField textField = new TextField(H2Fulltext.fieldForIndex(indexName), buf.toString(), Field.Store.NO);
                doc.add((IndexableField)textField);
            }
            try {
                this.indexWriter.addDocument((Iterable)doc);
            }
            catch (IOException e) {
                throw H2Fulltext.convertException(e);
            }
            catch (AlreadyClosedException e) {
                log.error((Object)("org.apache.lucene.store.AlreadyClosedException in thread " + Thread.currentThread().getName() + ", last close was in thread " + this.lastIndexWriterCloseThread), (Throwable)this.lastIndexWriterClose);
                throw e;
            }
        }

        private void delete(Object[] row) throws SQLException {
            String primaryKey = H2Fulltext.asString(row[this.primaryKeyIndex], this.primaryKeyType);
            try {
                this.indexWriter.deleteDocuments(new Term[]{new Term("KEY", primaryKey)});
            }
            catch (IOException e) {
                throw H2Fulltext.convertException(e);
            }
        }

        public void close() throws SQLException {
            if (this.indexWriter != null) {
                try {
                    this.lastIndexWriterClose = new RuntimeException("debug stack trace");
                    this.lastIndexWriterCloseThread = Thread.currentThread().getName();
                    this.indexWriter.close();
                    this.indexWriter = null;
                }
                catch (IOException e) {
                    throw H2Fulltext.convertException(e);
                }
                finally {
                    indexWriters.remove(this.indexName);
                }
            }
        }

        public void remove() {
        }
    }

    protected static class ResultSetCollector
    extends Collector {
        protected final SimpleResultSet rs;
        protected IndexReader reader;
        protected int type;
        protected int docBase;

        public ResultSetCollector(SimpleResultSet rs, IndexReader reader, int type) {
            this.rs = rs;
            this.reader = reader;
            this.type = type;
        }

        public void setNextReader(AtomicReaderContext context) {
            this.docBase = context.docBase;
        }

        public void setScorer(Scorer scorer) {
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        public void collect(int docID) throws IOException {
            Document doc = this.reader.document(docID += this.docBase, Collections.singleton("KEY"));
            try {
                Object key = H2Fulltext.asObject(doc.get("KEY"), this.type);
                this.rs.addRow(new Object[]{key});
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }
}

