/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.io.Serializable;
import org.nuxeo.ecm.core.cache.AbstractCache;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheDescriptor;

public class CacheAttributesChecker
extends AbstractCache {
    protected Cache cache;

    protected CacheAttributesChecker(CacheDescriptor desc) {
        super(desc);
    }

    void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    @Override
    public Serializable get(String key) {
        if (key == null) {
            return null;
        }
        return this.cache.get(key);
    }

    @Override
    public void invalidate(String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Can't invalidate a null key for the cache '%s'!", this.name));
        }
        this.cache.invalidate(key);
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public void put(String key, Serializable value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Can't put a null key for the cache '%s'!", this.name));
        }
        this.cache.put(key, value);
    }

    @Override
    public boolean hasEntry(String key) {
        if (key == null) {
            return false;
        }
        return this.cache.hasEntry(key);
    }
}

