/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.api.PublishingEvent;
import org.nuxeo.ecm.platform.publisher.rules.ValidatorsRule;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractBasePublishedDocumentFactory
implements PublishedDocumentFactory {
    public static final String ENABLE_SNAPSHOT = "enableSnapshot";
    public static final String TARGET_PUBLISHED_DOCUMENT_STATE = "targetPublishedDocumentState";
    protected CoreSession coreSession;
    protected Map<String, String> parameters;
    protected PublicationTree publicationTree;
    protected ValidatorsRule validatorsRule;
    protected EventProducer eventProducer;

    @Override
    public void init(CoreSession coreSession, ValidatorsRule validatorsRule, Map<String, String> parameters) {
        this.coreSession = coreSession;
        this.parameters = parameters;
        this.validatorsRule = validatorsRule;
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
    }

    @Override
    public void init(CoreSession coreSession, Map<String, String> parameters) {
        this.init(coreSession, null, parameters);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    protected String getParameter(String name) {
        return this.parameters.get(name);
    }

    protected boolean isSnapshotingEnabled() {
        String snap = this.getParameter(ENABLE_SNAPSHOT);
        if (snap == null) {
            return false;
        }
        return snap.equalsIgnoreCase("true");
    }

    protected String getTargetPublishedDocumentState() {
        return this.getParameter(TARGET_PUBLISHED_DOCUMENT_STATE);
    }

    @Override
    public PublishedDocument publishDocument(DocumentModel doc, PublicationNode targetNode) {
        return this.publishDocument(doc, targetNode, null);
    }

    protected boolean needToVersionDocument(DocumentModel doc) {
        return !doc.isVersion() && doc.isVersionable();
    }

    @Override
    public DocumentModel snapshotDocumentBeforePublish(DocumentModel doc) {
        if (this.isSnapshotingEnabled() && this.needToVersionDocument(doc)) {
            if (doc.isCheckedOut()) {
                doc.checkIn(VersioningOption.MINOR, null);
            }
            this.coreSession.save();
            List versions = this.coreSession.getVersions(doc.getRef());
            return (DocumentModel)versions.get(versions.size() - 1);
        }
        return doc;
    }

    @Override
    public String[] getValidatorsFor(DocumentModel dm) {
        return this.validatorsRule.computesValidatorsFor(dm);
    }

    @Override
    public ValidatorsRule getValidatorsRule() {
        return this.validatorsRule;
    }

    @Override
    public void validatorPublishDocument(PublishedDocument publishedDocument, String comment) {
    }

    @Override
    public void validatorRejectPublication(PublishedDocument publishedDocument, String comment) {
    }

    @Override
    public boolean canManagePublishing(PublishedDocument publishedDocument) {
        return false;
    }

    @Override
    public boolean hasValidationTask(PublishedDocument publishedDocument) {
        return false;
    }

    protected void notifyEvent(PublishingEvent event, DocumentModel doc, CoreSession coreSession) {
        this.notifyEvent(event.name(), null, null, null, doc, coreSession);
    }

    protected void notifyEvent(String eventId, Map<String, Serializable> properties, String comment, String category, DocumentModel dm, CoreSession coreSession) {
        if (category == null) {
            category = "eventDocumentCategory";
        }
        if (properties == null) {
            properties = new HashMap<String, Serializable>();
        }
        properties.put("repositoryName", (Serializable)((Object)dm.getRepositoryName()));
        properties.put("sessionId", (Serializable)((Object)coreSession.getSessionId()));
        properties.put("documentLifeCycle", (Serializable)((Object)dm.getCurrentLifeCycleState()));
        DocumentEventContext ctx = new DocumentEventContext(coreSession, coreSession.getPrincipal(), dm);
        ctx.setProperties(properties);
        ctx.setComment(comment);
        ctx.setCategory(category);
        Event event = ctx.newEvent(eventId);
        this.getEventProducer().fireEvent(event);
    }

    protected EventProducer getEventProducer() {
        if (this.eventProducer == null) {
            this.eventProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        return this.eventProducer;
    }
}

