/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.helper;

import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.platform.preview.adapter.base.ConverterBasedHtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.api.HtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.api.PreviewException;

public class PreviewHelper {
    public static final String REST_API_PREFIX = "site/api/v1";
    protected static final Map<String, Boolean> hasPreviewByType = new ConcurrentHashMap<String, Boolean>();

    private PreviewHelper() {
    }

    public static String getPreviewURL(DocumentModel doc) {
        return PreviewHelper.getPreviewURL(doc, null);
    }

    public static String getPreviewURL(DocumentModel doc, String xpath) {
        StringJoiner sj = new StringJoiner("/", "", "/").add(REST_API_PREFIX).add("repo").add(doc.getRepositoryName()).add("id").add(doc.getId());
        if (xpath != null) {
            sj.add("@blob").add(xpath);
        }
        return sj.add("@preview").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean typeSupportsPreview(DocumentModel doc) {
        String docType = doc.getType();
        if (hasPreviewByType.containsKey(docType)) {
            return hasPreviewByType.get(docType);
        }
        HtmlPreviewAdapter adapter = (HtmlPreviewAdapter)doc.getAdapter(HtmlPreviewAdapter.class);
        if (adapter == null) {
            Map<String, Boolean> map = hasPreviewByType;
            synchronized (map) {
                hasPreviewByType.put(docType, false);
                return false;
            }
        }
        Map<String, Boolean> map = hasPreviewByType;
        synchronized (map) {
            hasPreviewByType.put(docType, true);
            return true;
        }
    }

    public static boolean docHasBlobToPreview(DocumentModel document) throws PreviewException {
        HtmlPreviewAdapter adapter = (HtmlPreviewAdapter)document.getAdapter(HtmlPreviewAdapter.class);
        return adapter != null && adapter.hasBlobToPreview();
    }

    public static boolean blobSupportsPreview(DocumentModel doc, String xpath) {
        HtmlPreviewAdapter adapter;
        if (PreviewHelper.isBlobHolder(doc, xpath)) {
            xpath = null;
        }
        return (adapter = PreviewHelper.getBlobPreviewAdapter(doc)) != null && adapter.hasPreview(xpath);
    }

    public static HtmlPreviewAdapter getBlobPreviewAdapter(DocumentModel doc) {
        ConverterBasedHtmlPreviewAdapter adapter = new ConverterBasedHtmlPreviewAdapter();
        adapter.setAdaptedDocument(doc);
        return adapter;
    }

    private static boolean isBlobHolder(DocumentModel doc, String xpath) {
        DocumentBlobHolder bh = (DocumentBlobHolder)doc.getAdapter(BlobHolder.class);
        return bh != null && bh.getXpath().equals(xpath);
    }
}

