/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.preview.adapter.AbstractPreviewer;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;

public class VideoPreviewer
extends AbstractPreviewer
implements MimeTypePreviewer {
    @Override
    public List<Blob> getPreview(Blob blob, DocumentModel dm) throws PreviewException {
        List<Blob> blobs = Arrays.asList(blob);
        return this.buildPreview(blobs, dm);
    }

    protected List<Blob> buildPreview(List<Blob> blobs, DocumentModel dm) {
        ArrayList<Blob> blobResults = new ArrayList<Blob>();
        String basePath = VirtualHostHelper.getContextPathProperty();
        StringBuffer html = new StringBuffer();
        html.append("<html><head>");
        html.append("<title>" + this.getPreviewTitle(dm) + "</title>");
        html.append(String.format("<script src=\"%s/bower_components/webcomponentsjs/webcomponents-lite.js\"></script>", basePath));
        html.append(String.format("<link rel=\"import\" href=\"%s/viewers/nuxeo-video-viewer.vulcanized.html\">", basePath));
        html.append("<nuxeo-video-viewer controls>");
        for (Blob blob : blobs) {
            html.append(String.format("<source src=\"%s\" type=\"%s\" />", blob.getFilename(), blob.getMimeType()));
            blobResults.add(blob);
        }
        html.append("</nuxeo-video-viewer>");
        html.append("</body>");
        Blob mainBlob = Blobs.createBlob((String)html.toString(), (String)"text/html", null, (String)"index.html");
        blobResults.add(0, mainBlob);
        return blobResults;
    }
}

