/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.service;

import org.nuxeo.ecm.platform.annotations.api.AnnotationsConstants;
import org.nuxeo.ecm.platform.annotations.api.AnnotationsService;
import org.nuxeo.ecm.platform.annotations.api.UriResolver;
import org.nuxeo.ecm.platform.annotations.descriptors.AnnotabilityManagerDescriptor;
import org.nuxeo.ecm.platform.annotations.descriptors.AnnotationIDGeneratorDescriptor;
import org.nuxeo.ecm.platform.annotations.descriptors.EventListenerDescriptor;
import org.nuxeo.ecm.platform.annotations.descriptors.MetadataMapperDescriptor;
import org.nuxeo.ecm.platform.annotations.descriptors.PermissionManagerDescriptor;
import org.nuxeo.ecm.platform.annotations.descriptors.PermissionMapperDescriptor;
import org.nuxeo.ecm.platform.annotations.descriptors.URLPatternFilterDescriptor;
import org.nuxeo.ecm.platform.annotations.descriptors.UriResolverDescriptor;
import org.nuxeo.ecm.platform.annotations.proxy.AnnotationServiceProxy;
import org.nuxeo.ecm.platform.annotations.service.AnnotabilityManager;
import org.nuxeo.ecm.platform.annotations.service.AnnotationConfigurationService;
import org.nuxeo.ecm.platform.annotations.service.AnnotationConfigurationServiceImpl;
import org.nuxeo.ecm.platform.annotations.service.AnnotationIDGenerator;
import org.nuxeo.ecm.platform.annotations.service.EventListener;
import org.nuxeo.ecm.platform.annotations.service.MetadataMapper;
import org.nuxeo.ecm.platform.annotations.service.PermissionManager;
import org.nuxeo.ecm.platform.annotations.service.URLPatternFilter;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class AnnotationsComponent
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.annotations.services.annotationServiceFactory");
    private AnnotationServiceProxy annotationServiceProxy;
    private final AnnotationConfigurationService configuration = new AnnotationConfigurationServiceImpl();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        AnnotationsConstants.ExtensionPoint point = Enum.valueOf(AnnotationsConstants.ExtensionPoint.class, extensionPoint);
        switch (point) {
            case uriResolver: {
                UriResolver resolver = this.newInstance(((UriResolverDescriptor)contribution).getKlass());
                this.configuration.setUriResolver(resolver);
                break;
            }
            case urlPatternFilter: {
                URLPatternFilterDescriptor descriptor = (URLPatternFilterDescriptor)contribution;
                boolean order = descriptor.getOrder().equalsIgnoreCase("Allow,Deny");
                URLPatternFilter filter = new URLPatternFilter(order, descriptor.getDenies(), descriptor.getAllows());
                this.configuration.setFilter(filter);
                break;
            }
            case metadataMapper: {
                MetadataMapper mapper = this.newInstance(((MetadataMapperDescriptor)contribution).getKlass());
                this.configuration.setMetadataMapper(mapper);
                break;
            }
            case permissionManager: {
                PermissionManager manager = this.newInstance(((PermissionManagerDescriptor)contribution).getKlass());
                this.configuration.setPermissionManager(manager);
                break;
            }
            case annotabilityManager: {
                AnnotabilityManager annotabilityManager = this.newInstance(((AnnotabilityManagerDescriptor)contribution).getKlass());
                this.configuration.setAnnotabilityManager(annotabilityManager);
                break;
            }
            case eventListener: {
                Class<? extends EventListener> listener = ((EventListenerDescriptor)contribution).getListener();
                this.configuration.addListener(this.newInstance(listener));
                break;
            }
            case annotationIDGenerator: {
                AnnotationIDGenerator generator = this.newInstance(((AnnotationIDGeneratorDescriptor)contribution).getKlass());
                this.configuration.setIDGenerator(generator);
                break;
            }
            case permissionMapper: {
                this.configuration.setPermissionMapper((PermissionMapperDescriptor)contribution);
            }
        }
    }

    protected <T> T newInstance(Class<T> klass) {
        try {
            return klass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public void activate(ComponentContext context) {
    }

    public void deactivate(ComponentContext context) {
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (AnnotationsService.class.isAssignableFrom(adapter)) {
            return (T)this.getAnnotationServiceProxy();
        }
        if (AnnotationConfigurationService.class.isAssignableFrom(adapter)) {
            return (T)this.configuration;
        }
        return null;
    }

    private AnnotationsService getAnnotationServiceProxy() {
        if (this.annotationServiceProxy == null) {
            this.annotationServiceProxy = new AnnotationServiceProxy();
            this.annotationServiceProxy.initialise();
        }
        return this.annotationServiceProxy;
    }
}

