/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelComparator;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryCache;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFieldMapper;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.runtime.metrics.MetricsService;

public abstract class AbstractDirectory
implements Directory {
    public final BaseDirectoryDescriptor descriptor;
    protected DirectoryFieldMapper fieldMapper;
    protected final Map<String, List<Reference>> references = new HashMap<String, List<Reference>>();
    protected final DirectoryCache cache;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Counter sessionCount;
    protected final Counter sessionMaxCount;

    protected AbstractDirectory(BaseDirectoryDescriptor descriptor) {
        this.descriptor = descriptor;
        if (!descriptor.template && this.doSanityChecks()) {
            if (StringUtils.isEmpty((String)descriptor.idField)) {
                throw new DirectoryException("idField configuration is missing for directory: " + this.getName());
            }
            if (StringUtils.isEmpty((String)descriptor.schemaName)) {
                throw new DirectoryException("schema configuration is missing for directory " + this.getName());
            }
        }
        this.cache = new DirectoryCache(this.getName());
        this.sessionCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", this.getName(), "sessions", "active"}));
        this.sessionMaxCount = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", this.getName(), "sessions", "max"}));
    }

    protected boolean doSanityChecks() {
        return true;
    }

    public abstract BaseDirectoryDescriptor getDescriptor();

    public String getName() {
        return this.descriptor.name;
    }

    public String getSchema() {
        return this.descriptor.schemaName;
    }

    public String getParentDirectory() {
        return this.descriptor.parentDirectory;
    }

    public String getIdField() {
        return this.descriptor.idField;
    }

    public String getPasswordField() {
        return this.descriptor.passwordField;
    }

    public boolean isReadOnly() {
        return this.descriptor.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.descriptor.setReadOnly(readOnly);
    }

    public void invalidateCaches() throws DirectoryException {
        this.cache.invalidateAll();
        for (Reference ref : this.getReferences()) {
            Directory targetDir = ref.getTargetDirectory();
            if (targetDir == null) continue;
            targetDir.invalidateDirectoryCache();
        }
    }

    public DirectoryFieldMapper getFieldMapper() {
        if (this.fieldMapper == null) {
            this.fieldMapper = new DirectoryFieldMapper();
        }
        return this.fieldMapper;
    }

    @Deprecated
    public Reference getReference(String referenceFieldName) {
        List<Reference> refs = this.getReferences(referenceFieldName);
        if (refs == null || refs.isEmpty()) {
            return null;
        }
        if (refs.size() == 1) {
            return refs.get(0);
        }
        throw new DirectoryException("Unexpected multiple references for " + referenceFieldName + " in directory " + this.getName());
    }

    public List<Reference> getReferences(String referenceFieldName) {
        return this.references.get(referenceFieldName);
    }

    public boolean isReference(String referenceFieldName) {
        return this.references.containsKey(referenceFieldName);
    }

    public void addReference(Reference reference) {
        List<Reference> fieldRefs;
        reference.setSourceDirectoryName(this.getName());
        String fieldName = reference.getFieldName();
        if (this.references.containsKey(fieldName)) {
            fieldRefs = this.references.get(fieldName);
        } else {
            fieldRefs = new ArrayList<Reference>(1);
            this.references.put(fieldName, fieldRefs);
        }
        fieldRefs.add(reference);
    }

    public void addReferences(Reference[] refs) {
        for (Reference reference : refs) {
            this.addReference(reference);
        }
    }

    public Collection<Reference> getReferences() {
        ArrayList<Reference> allRefs = new ArrayList<Reference>(2);
        for (List<Reference> refs : this.references.values()) {
            allRefs.addAll(refs);
        }
        return allRefs;
    }

    public void orderEntries(List<DocumentModel> entries, Map<String, String> orderBy) throws DirectoryException {
        Collections.sort(entries, new DocumentModelComparator(this.getSchema(), orderBy));
    }

    public DirectoryCache getCache() {
        return this.cache;
    }

    public void removeSession(Session session) {
        this.sessionCount.dec();
    }

    public void addSession(Session session) {
        this.sessionCount.inc();
        if (this.sessionCount.getCount() > this.sessionMaxCount.getCount()) {
            this.sessionMaxCount.inc();
        }
    }

    public void invalidateDirectoryCache() throws DirectoryException {
        this.getCache().invalidateAll();
    }

    public boolean isMultiTenant() {
        return false;
    }

    public void shutdown() {
        this.sessionCount.dec(this.sessionCount.getCount());
        this.sessionMaxCount.dec(this.sessionMaxCount.getCount());
    }
}

