/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jsf.operations;

import java.io.IOException;
import java.util.UUID;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Operation(id="WebUI.DownloadFile", category="User Interface", requires="Seam", label="Download file", description="Download a file", aliases={"Seam.DownloadFile"})
public class DownloadFile {
    protected static Log log = LogFactory.getLog(DownloadFile.class);
    public static final String ID = "WebUI.DownloadFile";
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public void run(Blob blob) throws OperationException, IOException {
        if (blob == null) {
            throw new OperationException("there is no file content available");
        }
        String filename = blob.getFilename();
        if (blob.getLength() > Functions.getBigFileSizeLimit()) {
            ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
            HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
            HttpServletResponse response = (HttpServletResponse)externalContext.getResponse();
            String sid = UUID.randomUUID().toString();
            request.getSession(true).setAttribute(sid, (Object)blob);
            String bigDownloadURL = BaseURL.getBaseURL((ServletRequest)request);
            bigDownloadURL = bigDownloadURL + "nxbigblob/" + sid;
            try {
                request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)new Boolean(true));
                response.sendRedirect(bigDownloadURL);
                response.flushBuffer();
                FacesContext.getCurrentInstance().responseComplete();
                this.ctx.getVars().put("Outcome", null);
            }
            catch (IOException e) {
                log.error((Object)"Error while redirecting for big blob downloader", (Throwable)e);
            }
        } else {
            ComponentUtils.download(null, null, (Blob)blob, (String)filename, (String)"operation");
        }
    }
}

