/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.security;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class ACE
implements Serializable,
Cloneable {
    public static final ACE BLOCK = new ACE("Everyone", "Everything", false);
    private final String username;
    private final String permission;
    private final boolean isGranted;
    private Calendar begin;
    private Calendar end;
    private String creator;
    private Map<String, Serializable> contextData = new HashMap<String, Serializable>();

    public static ACE fromId(String aceId) {
        if (aceId == null) {
            return null;
        }
        String[] parts = aceId.split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException(String.format("Invalid ACE id: %s", aceId));
        }
        String username = parts[0];
        String permission = parts[1];
        boolean isGranted = Boolean.valueOf(parts[2]);
        ACEBuilder builder = ACE.builder(username, permission).isGranted(isGranted);
        if (parts.length >= 4 && StringUtils.isNotBlank((String)parts[3])) {
            builder.creator(parts[3]);
        }
        if (parts.length >= 5 && StringUtils.isNotBlank((String)parts[4])) {
            GregorianCalendar begin = new GregorianCalendar();
            begin.setTimeInMillis(Long.valueOf(parts[4]));
            builder.begin(begin);
        }
        if (parts.length >= 6 && StringUtils.isNotBlank((String)parts[5])) {
            GregorianCalendar end = new GregorianCalendar();
            end.setTimeInMillis(Long.valueOf(parts[5]));
            builder.end(end);
        }
        return builder.build();
    }

    public ACE() {
        this(null, null, false);
    }

    public ACE(String username, String permission, boolean isGranted) {
        this(username, permission, isGranted, null, null, null, null);
    }

    public ACE(String username, String permission) {
        this(username, permission, true);
    }

    ACE(String username, String permission, boolean isGranted, String creator, Calendar begin, Calendar end, Map<String, Serializable> contextData) {
        this.username = username;
        this.permission = permission;
        this.isGranted = isGranted;
        this.creator = creator;
        this.setBegin(begin);
        this.setEnd(end);
        if (contextData != null) {
            this.contextData = new HashMap<String, Serializable>(contextData);
        }
        if (begin != null && end != null && begin.after(end)) {
            throw new IllegalArgumentException("'begin' date cannot be after 'end' date");
        }
    }

    public String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.username);
        sb.append(':');
        sb.append(this.permission);
        sb.append(':');
        sb.append(this.isGranted);
        sb.append(':');
        if (this.creator != null) {
            sb.append(this.creator);
        }
        sb.append(':');
        if (this.begin != null) {
            sb.append(this.begin.getTimeInMillis());
        }
        sb.append(':');
        if (this.end != null) {
            sb.append(this.end.getTimeInMillis());
        }
        return sb.toString();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean isGranted() {
        return this.isGranted;
    }

    public boolean isDenied() {
        return !this.isGranted;
    }

    public Calendar getBegin() {
        return this.begin;
    }

    public void setBegin(Calendar begin) {
        this.begin = begin;
        if (this.begin != null) {
            this.begin.set(14, 0);
        }
    }

    public Calendar getEnd() {
        return this.end;
    }

    public void setEnd(Calendar end) {
        this.end = end;
        if (this.end != null) {
            this.end.set(14, 0);
        }
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Status getStatus() {
        Status status = Status.EFFECTIVE;
        GregorianCalendar now = new GregorianCalendar();
        if (this.begin != null && now.before(this.begin)) {
            status = Status.PENDING;
        }
        if (this.end != null && now.after(this.end)) {
            status = Status.ARCHIVED;
        }
        return status;
    }

    public Long getLongStatus() {
        if (this.begin == null && this.end == null) {
            return null;
        }
        return this.getStatus().ordinal();
    }

    public boolean isEffective() {
        return this.getStatus() == Status.EFFECTIVE;
    }

    public boolean isPending() {
        return this.getStatus() == Status.PENDING;
    }

    public boolean isArchived() {
        return this.getStatus() == Status.ARCHIVED;
    }

    public Serializable getContextData(String key) {
        return this.contextData.get(key);
    }

    public void putContextData(String key, Serializable value) {
        this.contextData.put(key, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ACE) {
            boolean creatorEqual;
            boolean endEqual;
            ACE ace = (ACE)obj;
            boolean beginEqual = ace.begin == null && this.begin == null || ace.begin != null && this.begin != null && ace.begin.getTimeInMillis() == this.begin.getTimeInMillis();
            boolean bl = endEqual = ace.end == null && this.end == null || ace.end != null && this.end != null && ace.end.getTimeInMillis() == this.end.getTimeInMillis();
            boolean bl2 = ace.creator != null ? ace.creator.equals(this.creator) : (creatorEqual = this.creator == null);
            boolean usernameEqual = ace.username != null ? ace.username.equals(this.username) : this.username == null;
            return ace.isGranted == this.isGranted && usernameEqual && ace.permission.equals(this.permission) && creatorEqual && beginEqual && endEqual;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 37 + (this.isGranted ? 1 : 0);
        hash = hash * 37 + this.username.hashCode();
        hash = this.creator != null ? hash * 37 + this.creator.hashCode() : hash;
        hash = this.begin != null ? hash * 37 + this.begin.hashCode() : hash;
        hash = this.end != null ? hash * 37 + this.end.hashCode() : hash;
        return hash * 37 + this.permission.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('(');
        sb.append("username=").append(this.username);
        sb.append(", ");
        sb.append("permission=" + this.permission);
        sb.append(", ");
        sb.append("isGranted=" + this.isGranted);
        sb.append(", ");
        sb.append("creator=" + this.creator);
        sb.append(", ");
        sb.append("begin=" + (this.begin != null ? Long.valueOf(this.begin.getTimeInMillis()) : null));
        sb.append(", ");
        sb.append("end=" + (this.end != null ? Long.valueOf(this.end.getTimeInMillis()) : null));
        sb.append(')');
        return sb.toString();
    }

    public Object clone() {
        return new ACE(this.username, this.permission, this.isGranted, this.creator, this.begin, this.end, this.contextData);
    }

    public static ACEBuilder builder(String username, String permission) {
        return new ACEBuilder(username, permission);
    }

    public static class ACEBuilder {
        private String username;
        private String permission;
        private boolean isGranted = true;
        private Calendar begin;
        private Calendar end;
        private String creator;
        private Map<String, Serializable> contextData;

        public ACEBuilder(String username, String permission) {
            this.username = username;
            this.permission = permission;
        }

        public ACEBuilder isGranted(boolean isGranted) {
            this.isGranted = isGranted;
            return this;
        }

        public ACEBuilder begin(Calendar begin) {
            this.begin = begin;
            return this;
        }

        public ACEBuilder end(Calendar end) {
            this.end = end;
            return this;
        }

        public ACEBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public ACEBuilder contextData(Map<String, Serializable> contextData) {
            this.contextData = contextData;
            return this;
        }

        public ACE build() {
            return new ACE(this.username, this.permission, this.isGranted, this.creator, this.begin, this.end, this.contextData);
        }
    }

    public static enum Status {
        PENDING,
        EFFECTIVE,
        ARCHIVED;

    }
}

