/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.blobholder;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;

public abstract class AbstractBlobHolder
implements BlobHolder {
    @Override
    public abstract Blob getBlob();

    @Override
    public void setBlob(Blob blob) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Blob> getBlobs() {
        ArrayList<Blob> blobs = null;
        Blob blob = this.getBlob();
        if (blob != null) {
            blobs = new ArrayList<Blob>();
            blobs.add(blob);
        }
        return blobs;
    }

    protected abstract String getBasePath();

    @Override
    public String getFilePath() {
        String path = this.getBasePath();
        Blob blob = this.getBlob();
        if (blob != null) {
            path = path + "/" + blob.getFilename();
        }
        return path;
    }

    @Override
    public String getHash() {
        Blob blob = this.getBlob();
        if (blob != null) {
            String h = blob.getDigest();
            if (h == null) {
                h = this.getMD5Digest();
                blob.setDigest(h);
            }
            return h;
        }
        return "NullBlob";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getMD5Digest() {
        try (InputStream in = this.getBlob().getStream();){
            String string = DigestUtils.md5Hex((InputStream)in);
            return string;
        }
        catch (IOException e) {
            throw new NuxeoException(e);
        }
    }

    @Override
    public abstract Calendar getModificationDate();
}

