/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.audit.pageprovider;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.comment.CommentProcessorHelper;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.elasticsearch.audit.ESAuditBackend;
import org.nuxeo.elasticsearch.audit.io.AuditEntryJSONReader;
import org.nuxeo.runtime.api.Framework;

public class ESAuditPageProvider
extends AbstractPageProvider<LogEntry>
implements PageProvider<LogEntry> {
    private static final long serialVersionUID = 1L;
    protected SearchRequestBuilder searchBuilder;
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String UICOMMENTS_PROPERTY = "generateUIComments";
    protected static String emptyQuery = "{ \"match_all\" : { }\n }";

    public String toString() {
        this.buildAuditQuery(true);
        StringBuffer sb = new StringBuffer();
        sb.append(this.searchBuilder.toString());
        return sb.toString();
    }

    protected CoreSession getCoreSession() {
        Object session = this.getProperties().get(CORE_SESSION_PROPERTY);
        if (session != null && session instanceof CoreSession) {
            return (CoreSession)session;
        }
        return null;
    }

    protected void preprocessCommentsIfNeeded(List<LogEntry> entries) {
        CoreSession session;
        Serializable preprocess = (Serializable)this.getProperties().get(UICOMMENTS_PROPERTY);
        if (preprocess != null && "true".equalsIgnoreCase(preprocess.toString()) && (session = this.getCoreSession()) != null) {
            CommentProcessorHelper cph = new CommentProcessorHelper(session);
            cph.processComments(entries);
        }
    }

    public List<LogEntry> getCurrentPage() {
        this.buildAuditQuery(true);
        this.searchBuilder.setFrom((int)(this.getCurrentPageIndex() * this.pageSize));
        this.searchBuilder.setSize((int)this.getMinMaxPageSize());
        for (SortInfo sortInfo : this.getSortInfos()) {
            this.searchBuilder.addSort(sortInfo.getSortColumn(), sortInfo.getSortAscending() ? SortOrder.ASC : SortOrder.DESC);
        }
        SearchResponse searchResponse = (SearchResponse)this.searchBuilder.execute().actionGet();
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        SearchHits hits = searchResponse.getHits();
        this.setResultsCount(hits.getTotalHits());
        for (SearchHit hit : hits) {
            try {
                entries.add(AuditEntryJSONReader.read(hit.getSourceAsString()));
            }
            catch (IOException e) {
                log.error((Object)"Error while reading Audit Entry from ES", (Throwable)e);
            }
        }
        this.preprocessCommentsIfNeeded(entries);
        long t0 = System.currentTimeMillis();
        CoreSession session = this.getCoreSession();
        if (session != null) {
            this.fireSearchEvent(session.getPrincipal(), this.searchBuilder.toString(), entries, System.currentTimeMillis() - t0);
        }
        return entries;
    }

    protected boolean isNonNullParam(Object[] val) {
        if (val == null) {
            return false;
        }
        for (Object v : val) {
            if (v == null) continue;
            if (v instanceof String) {
                if (((String)v).isEmpty()) continue;
                return true;
            }
            if (v instanceof String[]) {
                if (((String[])v).length <= 0) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    protected String getFixedPart() {
        if (this.getDefinition().getWhereClause() == null) {
            return null;
        }
        String fixedPart = this.getDefinition().getWhereClause().getFixedPart();
        if (fixedPart == null || fixedPart.isEmpty()) {
            fixedPart = emptyQuery;
        }
        return fixedPart;
    }

    protected boolean allowSimplePattern() {
        return true;
    }

    protected ESAuditBackend getESBackend() {
        NXAuditEventsService audit = (NXAuditEventsService)Framework.getRuntime().getComponent(NXAuditEventsService.NAME);
        AuditBackend backend = audit.getBackend();
        if (backend instanceof ESAuditBackend) {
            return (ESAuditBackend)backend;
        }
        throw new NuxeoException("Unable to use ESAuditPageProvider if audit service is not configured to run with ElasticSearch");
    }

    protected void buildAuditQuery(boolean includeSort) {
        PageProviderDefinition def = this.getDefinition();
        Object[] params = this.getParameters();
        if (def.getWhereClause() == null) {
            if (!this.allowSimplePattern()) {
                throw new UnsupportedOperationException("This page provider requires a explicit Where Clause");
            }
            String baseQuery = this.getESBackend().expandQueryVariables(def.getPattern(), params);
            this.searchBuilder = this.getESBackend().buildQuery(baseQuery, null);
        } else {
            String baseQuery = this.getESBackend().expandQueryVariables(this.getFixedPart(), params);
            this.searchBuilder = this.getESBackend().buildSearchQuery(baseQuery, def.getWhereClause().getPredicates(), this.getSearchDocumentModel());
        }
    }

    public void refresh() {
        this.setCurrentPageOffset(0L);
        super.refresh();
    }

    public long getResultsCount() {
        return this.resultsCount;
    }

    public List<SortInfo> getSortInfos() {
        List sortInfos = super.getSortInfos();
        for (SortInfo si : sortInfos) {
            if (!si.getSortColumn().startsWith("log.")) continue;
            si.setSortColumn(si.getSortColumn().substring(4));
        }
        return sortInfos;
    }
}

