/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.DocWriter;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfColorList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] COLOR_TABLE = DocWriter.getISOBytes((String)"\\colortbl");
    ArrayList colorList = new ArrayList();

    public RtfColorList(RtfDocument doc) {
        super(doc);
        this.colorList.add(new RtfColor(doc, 0, 0, 0, 0));
        this.colorList.add(new RtfColor(doc, 255, 255, 255, 1));
    }

    public int getColorNumber(RtfColor color) {
        int colorIndex = -1;
        for (int i = 0; i < this.colorList.size(); ++i) {
            if (!this.colorList.get(i).equals(color)) continue;
            colorIndex = i;
        }
        if (colorIndex == -1) {
            colorIndex = this.colorList.size();
            this.colorList.add(color);
        }
        return colorIndex;
    }

    @Override
    public void writeContent(OutputStream out) throws IOException {
    }

    @Override
    public void writeDefinition(OutputStream result) throws IOException {
        result.write(OPEN_GROUP);
        result.write(COLOR_TABLE);
        for (int i = 0; i < this.colorList.size(); ++i) {
            RtfColor color = (RtfColor)this.colorList.get(i);
            color.writeDefinition(result);
        }
        result.write(CLOSE_GROUP);
        this.document.outputDebugLinebreak(result);
    }
}

