/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.wizard;

import com.google.common.base.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.functionaltests.Locator;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;

public class IFrameHelper {
    protected static final Log log = LogFactory.getLog(IFrameHelper.class);
    public static final String CONNECT_IFRAME_URL_PATTERN = "/register/";
    public static final String CALLBACK_URL_PATTERN = "ConnectCallback";
    public static final String CONNECT_FRAME_NAME = "connectForm";

    private static void switchToIFrame(WebDriver driver, final WebElement iframe) {
        FluentWait wait = Locator.getFluentWait().ignoring(NoSuchFrameException.class, StaleElementReferenceException.class);
        wait.until((Function)new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                if (iframe == null) {
                    return driver.switchTo().defaultContent() != null;
                }
                return driver.switchTo().frame(iframe) != null;
            }
        });
    }

    public static boolean focusOnConnectFrame(WebDriver driver) {
        if (!driver.getCurrentUrl().contains(CONNECT_IFRAME_URL_PATTERN)) {
            try {
                WebElement connectFormIFrame = Locator.findElementWithTimeout(By.id((String)CONNECT_FRAME_NAME));
                IFrameHelper.switchToIFrame(driver, connectFormIFrame);
            }
            catch (TimeoutException e) {
                log.error((Object)("Unable to find IFrame on page " + driver.getCurrentUrl()));
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean focusOnWizardPage(WebDriver driver) {
        Locator.waitUntilURLNotContain(CALLBACK_URL_PATTERN);
        try {
            IFrameHelper.switchToIFrame(driver, null);
            return true;
        }
        catch (TimeoutException e) {
            log.error((Object)("Unable to find top windows on page " + driver.getCurrentUrl()));
            return false;
        }
    }
}

