/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.wizard;

import com.google.common.base.Function;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.nuxeo.functionaltests.pages.wizard.AbstractWizardPage;
import org.nuxeo.functionaltests.pages.wizard.IFrameHelper;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ConnectWizardPage
extends AbstractWizardPage {
    protected static final String REGISTER_DIV_LOCATOR = "//div[@class='CSS_CLASS']";

    public ConnectWizardPage(WebDriver driver) {
        super(driver);
        IFrameHelper.focusOnConnectFrame(driver);
    }

    @Override
    public String getTitle() {
        WebElement title = ConnectWizardPage.findElementWithTimeout(By.xpath((String)"//header//div[@class='label']"));
        return title.getText().trim();
    }

    public void exitIframe() {
    }

    public String getErrorMessage() {
        WebElement el = ConnectWizardPage.findElementWithTimeout(By.cssSelector((String)"div.ui.warning.message"));
        if (el == null) {
            return null;
        }
        return el.getText().trim();
    }

    @Override
    protected By getNextButtonLocator() {
        return By.xpath((String)REGISTER_DIV_LOCATOR.replace("CSS_CLASS", "ui blue submit button btnNext"));
    }

    @Override
    protected By getPreviousButtonLocator() {
        return By.xpath((String)REGISTER_DIV_LOCATOR.replace("CSS_CLASS", "ui blue submit button btnPrev"));
    }

    public ConnectWizardPage openLink(String text) {
        ConnectWizardPage wpage = this.openLink(ConnectWizardPage.class, text);
        if (!this.driver.getCurrentUrl().contains("/register/")) {
            this.driver.switchTo().frame("connectForm");
            return this.asPage(ConnectWizardPage.class);
        }
        return wpage;
    }

    public ConnectWizardPage submitWithError() {
        return this.next(ConnectWizardPage.class, (Function<WebDriver, Boolean>)((Function)input -> this.findElementWithTimeout(By.cssSelector((String)".warning.message li"), 5000) != null));
    }

    public <T extends AbstractPage> T openLink(Class<T> wizardPageClass, String text) {
        WebElement link = ConnectWizardPage.findElementWithTimeout(By.linkText((String)text));
        if (link == null) {
            return null;
        }
        ConnectWizardPage.waitUntilEnabled(link);
        link.click();
        return (T)((AbstractPage)this.asPage(wizardPageClass));
    }

    public String getTitle2() {
        WebElement title2 = ConnectWizardPage.findElementWithTimeout(By.xpath((String)"//h2"));
        if (title2 == null) {
            return null;
        }
        return title2.getText();
    }
}

