/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.wizard;

import com.google.common.base.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.pages.AbstractPage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public abstract class AbstractWizardPage
extends AbstractPage {
    private static final Log log = LogFactory.getLog(AbstractWizardPage.class);
    protected static final String BUTTON_LOCATOR = "//input[@value=\"LABEL\"]";

    public AbstractWizardPage(WebDriver driver) {
        super(driver);
    }

    public String getTitle() {
        WebElement title = AbstractWizardPage.findElementWithTimeout(By.xpath((String)"//h1"));
        return title.getText().trim();
    }

    protected abstract By getNextButtonLocator();

    protected abstract By getPreviousButtonLocator();

    public <T extends AbstractWizardPage> T next(Class<T> wizardPageClass) {
        return this.next(wizardPageClass, null);
    }

    public <T extends AbstractWizardPage> T next(Class<T> wizardPageClass, Function<WebDriver, Boolean> function) {
        return (T)((AbstractWizardPage)this.nav(wizardPageClass, this.getNextButtonLocator(), function));
    }

    public <T extends AbstractWizardPage> T previous(Class<T> wizardPageClass) {
        return this.previous(wizardPageClass, null);
    }

    public <T extends AbstractWizardPage> T previous(Class<T> wizardPageClass, Function<WebDriver, Boolean> function) {
        return (T)((AbstractWizardPage)this.nav(wizardPageClass, this.getPreviousButtonLocator(), function));
    }

    public <T extends AbstractPage> T nav(Class<T> wizardPageClass, String buttonLabel) {
        return this.nav(wizardPageClass, buttonLabel, (Boolean)false);
    }

    public <T extends AbstractPage> T nav(Class<T> wizardPageClass, String buttonLabel, Boolean waitForURLChange) {
        return this.nav(wizardPageClass, this.getNavButtonLocator(buttonLabel), waitForURLChange);
    }

    protected <T extends AbstractPage> T nav(Class<T> wizardPageClass, By selector, Boolean waitForURLChange) {
        return this.nav(wizardPageClass, selector, (Function<WebDriver, Boolean>)(waitForURLChange != false ? null : input -> true));
    }

    protected <T extends AbstractPage> T nav(Class<T> wizardPageClass, By selector, Function<WebDriver, Boolean> function) {
        WebElement action = AbstractWizardPage.findElementWithTimeout(selector);
        String URLbefore = this.driver.getCurrentUrl();
        Locator.waitUntilEnabledAndClick(action);
        if (function == null) {
            this.waitUntilURLDifferentFrom(URLbefore);
        } else {
            Locator.waitUntilGivenFunction(function);
        }
        return (T)((AbstractPage)this.asPage(wizardPageClass));
    }

    public <T extends AbstractPage> T navByLink(Class<T> wizardPageClass, String linkLabel) {
        return this.navByLink(wizardPageClass, linkLabel, false);
    }

    public <T extends AbstractPage> T navByLink(Class<T> wizardPageClass, String linkLabel, Boolean waitForURLChange) {
        return this.nav(wizardPageClass, By.linkText((String)linkLabel), waitForURLChange);
    }

    public <T extends AbstractPage> T navById(Class<T> wizardPageClass, String buttonId) {
        return this.navById(wizardPageClass, buttonId, false);
    }

    public <T extends AbstractPage> T navById(Class<T> wizardPageClass, String buttonId, Boolean waitForURLChange) {
        return this.nav(wizardPageClass, By.id((String)buttonId), waitForURLChange);
    }

    protected By getNavButtonLocator(String label) {
        return By.xpath((String)BUTTON_LOCATOR.replace("LABEL", label));
    }

    public boolean fillInput(String name, String value) {
        WebElement element = AbstractWizardPage.findElementWithTimeout(By.name((String)name));
        if (element != null) {
            element.clear();
            element.sendKeys(new CharSequence[]{value});
            return true;
        }
        return false;
    }

    public boolean selectOption(String name, String value) {
        WebElement element = AbstractWizardPage.findElementWithTimeout(By.name((String)name));
        if (element != null) {
            Select select = new Select(element);
            select.selectByValue(value);
            return select.getFirstSelectedOption().getAttribute("value").equals(value);
        }
        return false;
    }

    public boolean selectOptionWithReload(String name, String value) {
        WebElement element = AbstractWizardPage.findElementWithTimeout(By.name((String)name));
        if (element != null) {
            Select select = new Select(element);
            select.selectByValue(value);
            element = AbstractWizardPage.findElementWithTimeout(By.name((String)name));
            select = new Select(element);
            return select.getFirstSelectedOption().getAttribute("value").equals(value);
        }
        return false;
    }

    public boolean clearInput(String name) {
        WebElement element = AbstractWizardPage.findElementWithTimeout(By.name((String)name));
        if (element != null) {
            element.clear();
            return true;
        }
        return false;
    }
}

