/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.tabs;

import java.util.List;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.DocumentBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class CommentsTabSubPage
extends DocumentBasePage {
    @Required
    @FindBy(linkText="Add a Comment")
    WebElement addComment;
    @FindBy(xpath="//textarea")
    WebElement commentTextarea;
    @FindBy(xpath="//input[@value='Add']")
    WebElement add;
    @FindBy(linkText="Reply")
    WebElement replyLink;
    @FindBy(linkText="Delete")
    WebElement deleteLink;

    public CommentsTabSubPage(WebDriver driver) {
        super(driver);
    }

    public CommentsTabSubPage addComment(String comment) {
        return this.addComment(comment, false);
    }

    public CommentsTabSubPage addComment(String comment, boolean reply) {
        if (reply) {
            this.replyLink.click();
        } else {
            this.addComment.click();
        }
        this.commentTextarea.clear();
        this.commentTextarea.sendKeys(new CharSequence[]{comment});
        Locator.scrollAndForceClick(this.add);
        return this.asPage(CommentsTabSubPage.class);
    }

    public boolean hasComment(String comment) {
        List elements = this.driver.findElements(By.xpath((String)"//div[contains(@class, 'commentQuote')]"));
        for (WebElement element : elements) {
            if (!element.getText().trim().equals(comment)) continue;
            return true;
        }
        return false;
    }

    public CommentsTabSubPage reply(String reply) {
        return this.addComment(reply, true);
    }

    public CommentsTabSubPage delete() {
        this.deleteLink.click();
        return this.asPage(CommentsTabSubPage.class);
    }

    public boolean canDelete() {
        try {
            return this.deleteLink.isEnabled();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }
}

