/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter.usermanagement;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.UsersGroupsBasePage;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.UsersTabSubPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class UserCreationFormPage
extends UsersGroupsBasePage {
    @FindBy(id="createUserView:createUser")
    WebElement form;
    @FindBy(name="createUserView:createUser:nxl_user:nxw_passwordMatcher_immediate_creation")
    List<WebElement> immediateCreation;
    @FindBy(id="createUserView:createUser:nxl_user:nxw_username")
    WebElement usernameInput;
    @FindBy(id="createUserView:createUser:nxl_user:nxw_firstname")
    WebElement firstnameInput;
    @FindBy(id="createUserView:createUser:nxl_user:nxw_lastname")
    WebElement lastnameInput;
    @FindBy(id="createUserView:createUser:nxl_user:nxw_company")
    WebElement companyInput;
    @FindBy(id="createUserView:createUser:nxl_user:nxw_email")
    WebElement emailInput;
    @FindBy(id="createUserView:createUser:nxl_user:nxw_passwordMatcher_firstPassword")
    WebElement firstPasswordInput;
    @FindBy(id="createUserView:createUser:nxl_user:nxw_passwordMatcher_secondPassword")
    WebElement secondPasswordInput;
    @FindBy(id="createUserView:createUser:button_save")
    WebElement createButton;
    @Required
    @FindBy(xpath="//div[@class=\"tabsContent\"]//input[@value=\"Cancel\"]")
    WebElement cancelButton;

    public UserCreationFormPage(WebDriver driver) {
        super(driver);
    }

    public UsersGroupsBasePage createUser(String username, String firstname, String lastname, String company, String email, String password, String group) throws NoSuchElementException {
        return this.createUser(username, firstname, lastname, company, email, password, group, false);
    }

    public UsersGroupsBasePage inviteUser(String username, String firstname, String lastname, String company, String email, String group) throws NoSuchElementException {
        return this.createUser(username, firstname, lastname, company, email, "", group, true);
    }

    private boolean isObjectChecked(int index) {
        assert (index < 2 && index >= 0);
        Assert.assertNotNull(this.immediateCreation);
        Assert.assertEquals((long)2L, (long)this.immediateCreation.size());
        return this.immediateCreation.get(index).isSelected();
    }

    public boolean isImmediateCreationYesSelected() {
        return this.isObjectChecked(1);
    }

    public UsersGroupsBasePage createUser(String username, String firstname, String lastname, String company, String email, String password, String group, boolean invite) throws NoSuchElementException {
        return this.createUser(username, firstname, lastname, company, email, password, password, group, invite);
    }

    public UsersGroupsBasePage createUser(String username, String firstname, String lastname, String company, String email, String password1, String password2, String group, boolean invite) throws NoSuchElementException {
        if (!invite) {
            this.switchCreationFormPage();
            this.usernameInput.sendKeys(new CharSequence[]{username});
            this.firstnameInput.sendKeys(new CharSequence[]{firstname});
            this.lastnameInput.sendKeys(new CharSequence[]{lastname});
            this.companyInput.sendKeys(new CharSequence[]{company});
            this.emailInput.sendKeys(new CharSequence[]{email});
            this.firstPasswordInput.sendKeys(new CharSequence[]{password1});
            this.secondPasswordInput.sendKeys(new CharSequence[]{password2});
            if (StringUtils.isNotBlank((CharSequence)group)) {
                Select2WidgetElement groups = new Select2WidgetElement(this.driver, this.driver.findElement(By.xpath((String)"//div[@id='s2id_createUserView:createUser:nxl_user:nxw_groups_select2']")), true);
                groups.selectValue(group);
            }
            AjaxRequestManager arm = new AjaxRequestManager(this.driver);
            arm.begin();
            this.createButton.click();
            arm.end();
        } else {
            this.usernameInput.sendKeys(new CharSequence[]{username});
            this.firstnameInput.sendKeys(new CharSequence[]{firstname});
            this.lastnameInput.sendKeys(new CharSequence[]{lastname});
            this.companyInput.sendKeys(new CharSequence[]{company});
            this.emailInput.sendKeys(new CharSequence[]{email});
            if (StringUtils.isNotBlank((CharSequence)group)) {
                Select2WidgetElement groups = new Select2WidgetElement(this.driver, this.driver.findElement(By.xpath((String)"//div[@id='s2id_createUserView:createUser:nxl_user:nxw_groups_select2']")), true);
                groups.selectValue(group);
            }
            AjaxRequestManager arm = new AjaxRequestManager(this.driver);
            arm.begin();
            this.createButton.click();
            arm.end();
        }
        return this.asPage(UsersGroupsBasePage.class);
    }

    public UsersTabSubPage cancelCreation() {
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        this.cancelButton.click();
        arm.end();
        return this.asPage(UsersTabSubPage.class);
    }

    protected void switchCreationFormPage() {
        if (!this.isImmediateCreationYesSelected()) {
            Locator.scrollAndForceClick(this.immediateCreation.get(1));
            Locator.waitUntilElementPresent(By.id((String)"createUserView:createUser:nxl_user:nxw_passwordMatcher_firstPassword"));
        }
    }

    public WebElement getForm() {
        return this.form;
    }
}

