/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter.usermanagement;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.GroupEditFormPage;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.GroupsTabSubPage;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.UsersGroupsBasePage;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class GroupViewTabSubPage
extends UsersGroupsBasePage {
    @Required
    @FindBy(xpath="//div[@id='nxw_adminCenterSubTabs_tab_content']//h1")
    WebElement groupName;
    @FindBy(id="viewGroupView:viewGroup")
    WebElement viewGroupForm;
    @FindBy(id="viewGroupView:viewGroup:nxl_group:nxw_group_label")
    WebElement groupLabel;
    @Required
    @FindBy(linkText="View")
    WebElement viewGroupTab;
    @FindBy(linkText="Delete")
    WebElement deleteGroupLink;
    @FindBy(linkText="Edit")
    WebElement editLink;

    public GroupViewTabSubPage(WebDriver driver) {
        super(driver);
    }

    public GroupsTabSubPage deleteGroup() {
        this.deleteGroupLink.click();
        Alert alert = this.driver.switchTo().alert();
        Assert.assertEquals((Object)"Delete group?", (Object)alert.getText());
        alert.accept();
        return this.asPage(GroupsTabSubPage.class);
    }

    public GroupEditFormPage getEditGroupTab() {
        GroupViewTabSubPage.waitUntilEnabledAndClick(this.editLink);
        return this.asPage(GroupEditFormPage.class);
    }

    public GroupsTabSubPage backToTheList() {
        GroupViewTabSubPage.findElementWaitUntilEnabledAndClick(By.linkText((String)"Back to the List"));
        return this.asPage(GroupsTabSubPage.class);
    }

    public String getGroupName() {
        return this.groupName.getText();
    }

    public String getGroupLabel() {
        return this.groupLabel.getText();
    }

    public List<String> getGroupMembers() {
        List userElements = this.viewGroupForm.findElements(By.className((String)"user"));
        ArrayList<String> users = new ArrayList<String>();
        for (WebElement userElement : userElements) {
            users.add(Locator.findParentTag(userElement, "a").getAttribute("title"));
        }
        return users;
    }

    public List<String> getSubGroupLabels() {
        List goupElements = this.viewGroupForm.findElements(By.className((String)"group"));
        ArrayList<String> groups = new ArrayList<String>();
        for (WebElement groupElement : goupElements) {
            groups.add(groupElement.getText());
        }
        return groups;
    }
}

