/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.admincenter.usermanagement;

import org.nuxeo.functionaltests.AjaxRequestManager;
import org.nuxeo.functionaltests.Locator;
import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.forms.Select2WidgetElement;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.GroupsTabSubPage;
import org.nuxeo.functionaltests.pages.admincenter.usermanagement.UsersGroupsBasePage;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class GroupCreationFormPage
extends UsersGroupsBasePage {
    @FindBy(id="createGroupView:createGroup:nxl_group:nxw_group_name")
    WebElement nameInput;
    @FindBy(id="createGroupView:createGroup:nxl_group:nxw_group_label")
    WebElement labelInput;
    @Required
    @FindBy(id="s2id_createGroupView:createGroup:nxl_group:nxw_group_members_select2")
    WebElement membersSelect;
    @Required
    @FindBy(id="s2id_createGroupView:createGroup:nxl_group:nxw_group_subgroups_select2")
    WebElement subgroupsSelect;
    @FindBy(id="createGroupView:createGroup:button_save")
    WebElement createButton;
    @Required
    @FindBy(xpath="//div[@class=\"tabsContent\"]//input[@value=\"Cancel\"]")
    WebElement cancelButton;

    public GroupCreationFormPage(WebDriver driver) {
        super(driver);
    }

    public UsersGroupsBasePage createGroup(String name, String label, String[] members, String[] subgroups) throws NoSuchElementException {
        this.nameInput.sendKeys(new CharSequence[]{name});
        this.labelInput.sendKeys(new CharSequence[]{label});
        if (members != null) {
            new Select2WidgetElement(this.driver, this.membersSelect, true).selectValues(members);
        }
        if (subgroups != null) {
            new Select2WidgetElement(this.driver, this.subgroupsSelect, true).selectValues(subgroups);
        }
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        Locator.waitUntilEnabledAndClick(this.createButton);
        arm.end();
        return this.asPage(UsersGroupsBasePage.class);
    }

    public GroupsTabSubPage cancelCreation() {
        AjaxRequestManager arm = new AjaxRequestManager(this.driver);
        arm.begin();
        Locator.waitUntilEnabledAndClick(this.cancelButton);
        arm.end();
        return this.asPage(GroupsTabSubPage.class);
    }
}

